/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.utils;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.cli.utils.CompilerHelper;
import io.cloudslang.lang.commons.services.api.CompilationHelper;
import io.cloudslang.lang.commons.services.api.SlangCompilationService;
import io.cloudslang.lang.commons.services.api.SlangSourceService;
import io.cloudslang.lang.compiler.Extension;
import io.cloudslang.lang.compiler.SlangSource;
import io.cloudslang.lang.compiler.modeller.result.CompilationModellingResult;
import io.cloudslang.lang.entities.CompilationArtifact;
import io.cloudslang.lang.entities.SystemProperty;
import io.cloudslang.lang.entities.bindings.values.Value;
import io.cloudslang.lang.entities.utils.SetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.yaml.snakeyaml.Yaml;

@Component
public class CompilerHelperImpl
implements CompilerHelper {
    private static final Logger logger = LogManager.getLogger(CompilerHelperImpl.class);
    private static final String SP_DIR = "properties";
    private static final String INPUT_DIR = "inputs";
    private static final String CONFIG_DIR = "configuration";
    private static final String DUPLICATE_SYSTEM_PROPERTY_ERROR_MESSAGE_PREFIX = "Duplicate system property: '";
    @Autowired
    private Slang slang;
    @Autowired
    private Yaml yaml;
    @Autowired
    private SlangSourceService slangSourceService;
    @Autowired
    private CompilationHelper compilationHelper;
    @Autowired
    private SlangCompilationService slangCompilationService;

    @Override
    public CompilationArtifact compile(String filePath, List<String> dependencies) {
        File file = this.slangCompilationService.getFile(filePath);
        try {
            return this.slang.compile(SlangSource.fromFile((File)file), this.getDependencySources(dependencies, file));
        }
        catch (Exception e) {
            this.handleException(file, e);
            return null;
        }
    }

    @Override
    public CompilationModellingResult compileSource(String filePath, List<String> dependencies) {
        File file = this.slangCompilationService.getFile(filePath);
        try {
            return this.slang.compileSource(SlangSource.fromFile((File)file), this.getDependencySources(dependencies, file));
        }
        catch (Exception e) {
            this.handleException(file, e);
            return null;
        }
    }

    private void handleException(File file, Exception e) {
        logger.error("Failed compilation for file : " + file.getName() + " ,Exception is : " + e.getMessage());
        throw new RuntimeException("Failed compilation for file : " + file.getName() + " ,Exception is : " + e.getMessage(), e);
    }

    @Override
    public List<CompilationModellingResult> compileFolders(List<String> foldersPaths) {
        return this.slangCompilationService.compileFolders(foldersPaths, this.compilationHelper);
    }

    @Override
    public Set<SystemProperty> loadSystemProperties(List<String> systemPropertyFiles) {
        String propertiesRelativePath = CONFIG_DIR + File.separator + SP_DIR;
        return this.loadPropertiesFromFiles(this.convertToFiles(systemPropertyFiles), Extension.getPropertiesFileExtensionValues(), propertiesRelativePath);
    }

    @Override
    public Map<String, Value> loadInputsFromFile(List<String> inputFiles) {
        String inputsRelativePath = CONFIG_DIR + File.separator + INPUT_DIR;
        return this.loadMapsFromFiles(this.convertToFiles(inputFiles), Extension.getYamlFileExtensionValues(), inputsRelativePath);
    }

    private Set<SlangSource> getDependencySources(List<String> dependencies, File file) {
        dependencies = this.getDependenciesIfEmpty(dependencies, file);
        return this.slangCompilationService.getSourcesFromFolders(dependencies);
    }

    private List<String> getDependenciesIfEmpty(List<String> dependencies, File file) {
        if (CollectionUtils.isEmpty(dependencies)) {
            dependencies = new ArrayList<String>();
            String appHome = System.getProperty("app.home", "");
            String contentRoot = appHome + File.separator + "content";
            File contentRootDir = new File(contentRoot);
            if (StringUtils.isNotEmpty((CharSequence)appHome) && contentRootDir.exists() && contentRootDir.isDirectory()) {
                dependencies.add(contentRoot);
            } else {
                dependencies.add(file.getParent());
            }
        }
        return dependencies;
    }

    private Map<String, Value> loadMapsFromFiles(List<File> files, String[] extensions, String directory) {
        Collection<File> fileCollection;
        if (CollectionUtils.isEmpty(files)) {
            fileCollection = this.loadDefaultFiles(extensions, directory, false);
            if (CollectionUtils.isEmpty(fileCollection)) {
                return null;
            }
        } else {
            fileCollection = files;
        }
        HashMap<String, Value> result = new HashMap<String, Value>();
        for (File inputFile : fileCollection) {
            logger.info("Loading file: " + inputFile);
            try {
                Map inputFileYamlContent;
                String inputsFileContent = SlangSource.fromFile((File)inputFile).getContent();
                Boolean emptyContent = true;
                if (StringUtils.isNotEmpty((CharSequence)inputsFileContent) && MapUtils.isNotEmpty((Map)(inputFileYamlContent = (Map)this.yaml.load(inputsFileContent)))) {
                    emptyContent = false;
                    result.putAll(this.slangSourceService.convertInputFromMap(inputFileYamlContent, inputFile.getName()));
                }
                if (!emptyContent.booleanValue()) continue;
                throw new RuntimeException("Inputs file: " + inputFile + " is empty or does not contain valid YAML content.");
            }
            catch (RuntimeException ex) {
                logger.error("Error loading file: " + inputFile + ". Nested exception is: " + ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private Set<SystemProperty> loadPropertiesFromFiles(List<File> files, String[] extensions, String directory) {
        Collection<File> fileCollection;
        if (CollectionUtils.isEmpty(files)) {
            fileCollection = this.loadDefaultFiles(extensions, directory, true);
            if (CollectionUtils.isEmpty(fileCollection)) {
                return new HashSet<SystemProperty>();
            }
        } else {
            fileCollection = files;
            for (File propertyFileCandidate : fileCollection) {
                Extension.validatePropertiesFileExtension((String)propertyFileCandidate.getName());
            }
        }
        HashMap<File, Set<SystemProperty>> loadedProperties = new HashMap<File, Set<SystemProperty>>();
        for (File propFile : fileCollection) {
            try {
                SlangSource source = SlangSource.fromFile((File)propFile);
                logger.info("Loading file: " + propFile);
                Set propsFromFile = this.slang.loadSystemProperties(source);
                this.mergeSystemProperties(loadedProperties, propsFromFile, propFile);
            }
            catch (Throwable ex) {
                String errorMessage = "Error loading file: " + propFile + " nested exception is " + ex.getMessage();
                logger.error(errorMessage, ex);
                throw new RuntimeException(errorMessage, ex);
            }
        }
        return SetUtils.mergeSets(loadedProperties.values());
    }

    private void mergeSystemProperties(Map<File, Set<SystemProperty>> target, Set<SystemProperty> propertiesFromFile, File sourceFile) {
        for (Map.Entry<File, Set<SystemProperty>> entry : target.entrySet()) {
            for (SystemProperty propertyFromFile : propertiesFromFile) {
                if (!SetUtils.containsIgnoreCaseBasedOnFqn(entry.getValue(), (SystemProperty)propertyFromFile)) continue;
                throw new RuntimeException(DUPLICATE_SYSTEM_PROPERTY_ERROR_MESSAGE_PREFIX + propertyFromFile.getFullyQualifiedName() + "' in the following files: " + entry.getKey().getPath() + ", " + sourceFile.getPath());
            }
        }
        target.put(sourceFile, propertiesFromFile);
    }

    private Collection<File> loadDefaultFiles(String[] extensions, String directory, boolean recursive) {
        String appHome = System.getProperty("app.home", "");
        String defaultDirectoryPath = appHome + File.separator + directory;
        File defaultDirectory = new File(defaultDirectoryPath);
        Collection<File> files = defaultDirectory.isDirectory() ? FileUtils.listFiles((File)defaultDirectory, (String[])extensions, (boolean)recursive) : Collections.emptyList();
        return files;
    }

    private List<File> convertToFiles(List<String> fileList) {
        return Lambda.convert(fileList, (Converter)new Converter<String, File>(){

            public File convert(String from) {
                return new File(from);
            }
        });
    }
}

