/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.services;

import io.cloudslang.lang.cli.services.ConsolePrinter;
import io.cloudslang.lang.runtime.events.LanguageEventData;
import io.cloudslang.score.events.ScoreEvent;
import io.cloudslang.score.events.ScoreEventListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.fusesource.jansi.Ansi;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncTriggerEventListener
implements ScoreEventListener {
    private static final String SLANG_STEP_ERROR_MSG = "Slang Error: ";
    private static final String SCORE_ERROR_EVENT_MSG = "Score Error Event:";
    private static final String FLOW_FINISHED_WITH_FAILURE_MSG = "Flow finished with failure";
    private static final String EXEC_START_PATH = "0";
    private static final int OUTPUT_VALUE_LIMIT = 100;
    private static final String STEP_PATH_PREFIX = "- ";
    private static final String FLOW_OUTPUTS = "Flow outputs:";
    private static final String OPERATION_OUTPUTS = "Operation outputs:";
    private static final String FINISHED_WITH_RESULT = " finished with result: ";
    private AtomicBoolean flowFinished = new AtomicBoolean(false);
    private AtomicReference<String> errorMessage = new AtomicReference<String>("");
    private boolean isDebugMode = false;
    @Autowired
    private ConsolePrinter consolePrinter;

    public synchronized void setIsDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    public boolean isFlowFinished() {
        return this.flowFinished.get();
    }

    public String getErrorMessage() {
        return this.errorMessage.get();
    }

    public synchronized void onEvent(ScoreEvent scoreEvent) throws InterruptedException {
        Map data = (Map)((Object)scoreEvent.getData());
        switch (scoreEvent.getEventType()) {
            case "SCORE_FINISHED_EVENT": {
                this.flowFinished.set(true);
                break;
            }
            case "SCORE_ERROR_EVENT": {
                this.errorMessage.set(SCORE_ERROR_EVENT_MSG + data.get("logMessage") + " , " + data.get("error_message"));
                break;
            }
            case "SCORE_FAILURE_EVENT": {
                this.consolePrinter.printWithColor(Ansi.Color.RED, FLOW_FINISHED_WITH_FAILURE_MSG);
                this.flowFinished.set(true);
                break;
            }
            case "MAVEN_DEPENDENCY_BUILD": {
                this.printDownloadArtifactMessage((String)data.get("MAVEN_DEPENDENCY_BUILD"));
                break;
            }
            case "MAVEN_DEPENDENCY_BUILD_FINISHED": {
                this.printDownloadArtifactMessage((String)data.get("MAVEN_DEPENDENCY_BUILD_FINISHED"));
                break;
            }
            case "SLANG_EXECUTION_EXCEPTION": {
                this.errorMessage.set(SLANG_STEP_ERROR_MSG + data.get("EXCEPTION"));
                break;
            }
            case "EVENT_STEP_START": {
                LanguageEventData eventData = (LanguageEventData)data;
                if (eventData.getStepType() != LanguageEventData.StepType.STEP) break;
                String stepName = eventData.getStepName();
                String path = eventData.getPath();
                int matches = StringUtils.countMatches((String)path, (String)".");
                String prefix = StringUtils.repeat((String)STEP_PATH_PREFIX, (int)matches);
                this.consolePrinter.printWithColor(Ansi.Color.YELLOW, prefix + stepName);
                break;
            }
            case "EVENT_OUTPUT_END": {
                if (((Serializable)data.get("STEP_TYPE")).equals(LanguageEventData.StepType.STEP)) {
                    if (!this.isDebugMode) break;
                    Map<String, Serializable> stepOutputs = SyncTriggerEventListener.extractNotEmptyOutputs(data);
                    String path = ((LanguageEventData)data).getPath();
                    int matches = StringUtils.countMatches((String)path, (String)".");
                    String prefix = StringUtils.repeat((String)STEP_PATH_PREFIX, (int)matches);
                    for (Map.Entry<String, Serializable> entry : stepOutputs.entrySet()) {
                        this.consolePrinter.printWithColor(Ansi.Color.WHITE, prefix + entry.getKey() + " = " + entry.getValue());
                    }
                } else {
                    Map<String, Serializable> outputs;
                    if (!data.containsKey("OUTPUTS") || !data.containsKey("PATH") || !((Serializable)data.get("PATH")).equals(EXEC_START_PATH) || (outputs = SyncTriggerEventListener.extractNotEmptyOutputs(data)).size() <= 0) break;
                    this.printForOperationOrFlow(data, Ansi.Color.WHITE, "\nOperation outputs:", "\nFlow outputs:");
                    for (Map.Entry<String, Serializable> entry : outputs.entrySet()) {
                        this.consolePrinter.printWithColor(Ansi.Color.WHITE, STEP_PATH_PREFIX + entry.getKey() + " = " + entry.getValue());
                    }
                }
                break;
            }
            case "EVENT_EXECUTION_FINISHED": {
                this.flowFinished.set(true);
                this.printFinishEvent(data);
                break;
            }
        }
    }

    private void printDownloadArtifactMessage(String message) {
        this.consolePrinter.printWithColor(Ansi.Color.CYAN, message);
    }

    public static Map<String, Serializable> extractNotEmptyOutputs(Map<String, Serializable> data) {
        Map originalOutputs = (Map)((Object)data.get("OUTPUTS"));
        HashMap<String, Serializable> extractedOutputs = new HashMap<String, Serializable>();
        if (MapUtils.isNotEmpty((Map)originalOutputs)) {
            for (Map.Entry output : originalOutputs.entrySet()) {
                if (output.getValue() == null || StringUtils.isEmpty((String)((Serializable)output.getValue()).toString())) continue;
                extractedOutputs.put((String)output.getKey(), (Serializable)((Object)StringUtils.abbreviate((String)((Serializable)output.getValue()).toString(), (int)0, (int)100)));
            }
            return extractedOutputs;
        }
        return new HashMap<String, Serializable>();
    }

    private void printFinishEvent(Map<String, Serializable> data) {
        String flowResult = (String)((Object)data.get("RESULT"));
        String flowName = (String)((Object)data.get("STEP_NAME"));
        this.printForOperationOrFlow(data, Ansi.Color.CYAN, "Operation: " + flowName + FINISHED_WITH_RESULT + flowResult, "Flow: " + flowName + FINISHED_WITH_RESULT + flowResult);
    }

    private void printForOperationOrFlow(Map<String, Serializable> data, Ansi.Color color, String operationMessage, String flowMessage) {
        if (LanguageEventData.StepType.OPERATION.equals((Object)data.get("STEP_TYPE"))) {
            this.consolePrinter.printWithColor(color, operationMessage);
        } else {
            this.consolePrinter.printWithColor(color, flowMessage);
        }
    }
}

