/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.services;

import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.cli.services.ScoreServices;
import io.cloudslang.lang.cli.services.SyncTriggerEventListener;
import io.cloudslang.lang.entities.CompilationArtifact;
import io.cloudslang.lang.entities.SystemProperty;
import io.cloudslang.lang.entities.bindings.values.Value;
import io.cloudslang.score.events.ScoreEventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class ScoreServicesImpl
implements ScoreServices {
    @Autowired
    private Slang slang;
    @Autowired
    private AutowireCapableBeanFactory autowireCapableBeanFactory;

    @Override
    public void subscribe(ScoreEventListener eventHandler, Set<String> eventTypes) {
        this.slang.subscribeOnEvents(eventHandler, eventTypes);
    }

    @Override
    public Long trigger(CompilationArtifact compilationArtifact, Map<String, Value> inputs, Set<SystemProperty> systemProperties) {
        return this.slang.run(compilationArtifact, inputs, systemProperties);
    }

    @Override
    public Long triggerSync(CompilationArtifact compilationArtifact, Map<String, Value> inputs, Set<SystemProperty> systemProperties, boolean isQuiet, boolean debug) {
        HashSet<String> handlerTypes = new HashSet<String>();
        if (isQuiet) {
            handlerTypes.add("EVENT_EXECUTION_FINISHED");
            handlerTypes.add("EVENT_OUTPUT_END");
        } else {
            handlerTypes.add("SCORE_FINISHED_EVENT");
            handlerTypes.add("SCORE_ERROR_EVENT");
            handlerTypes.add("SCORE_FAILURE_EVENT");
            handlerTypes.add("MAVEN_DEPENDENCY_BUILD");
            handlerTypes.add("MAVEN_DEPENDENCY_BUILD_FINISHED");
            handlerTypes.add("SLANG_EXECUTION_EXCEPTION");
            handlerTypes.add("EVENT_EXECUTION_FINISHED");
            handlerTypes.add("EVENT_STEP_START");
            handlerTypes.add("EVENT_OUTPUT_END");
        }
        SyncTriggerEventListener scoreEventListener = new SyncTriggerEventListener();
        this.autowireCapableBeanFactory.autowireBean((Object)scoreEventListener);
        scoreEventListener.setIsDebugMode(debug);
        this.slang.subscribeOnEvents((ScoreEventListener)scoreEventListener, handlerTypes);
        Long executionId = this.trigger(compilationArtifact, inputs, systemProperties);
        while (!scoreEventListener.isFlowFinished()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.slang.unSubscribeOnEvents((ScoreEventListener)scoreEventListener);
        String errorMessageFlowExecution = scoreEventListener.getErrorMessage();
        if (StringUtils.isNotEmpty((String)errorMessageFlowExecution)) {
            if (errorMessageFlowExecution.contains("supplied using a system property")) {
                errorMessageFlowExecution = errorMessageFlowExecution + "\n\nA system property file can be included using --spf <path_to_file>";
            }
            throw new RuntimeException(errorMessageFlowExecution);
        }
        return executionId;
    }
}

