/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.services;

import io.cloudslang.lang.cli.services.ConsolePrinter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class ConsolePrinterImpl
implements ConsolePrinter,
DisposableBean {
    private ThreadPoolExecutor singleThreadExecutor;
    private Future<?> lastTask;

    @PostConstruct
    public void initialize() {
        this.singleThreadExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    }

    public void destroy() throws Exception {
        this.singleThreadExecutor.shutdown();
        this.singleThreadExecutor = null;
    }

    @Override
    public synchronized void waitForAllPrintTasksToFinish() {
        try {
            if (this.lastTask != null) {
                this.lastTask.get(1L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized Future<?> printWithColor(Ansi.Color color, String message) {
        try {
            this.lastTask = this.singleThreadExecutor.submit(new ConsolePrinterRunnable(color, message));
            return this.lastTask;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
    }

    static class ConsolePrinterRunnable
    implements Runnable {
        private final Ansi.Color color;
        private final String message;

        ConsolePrinterRunnable(Ansi.Color color, String message) {
            this.color = color;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                AnsiConsole.out().print(Ansi.ansi().fg(this.color).a(this.message).newline());
                AnsiConsole.out().print(Ansi.ansi().fg(Ansi.Color.WHITE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            ConsolePrinterRunnable consolePrinterRunnable = (ConsolePrinterRunnable)object;
            return new EqualsBuilder().append((Object)this.color, (Object)consolePrinterRunnable.color).append((Object)this.message, (Object)consolePrinterRunnable.message).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.color).append((Object)this.message).toHashCode();
        }
    }
}

