/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MapConverter
implements Converter<Map<String, String>> {
    public static final String ESCAPE_EXPRESSION = "\\&^\\&";

    public boolean supports(Class<?> type, String optionContext) {
        return Map.class.isAssignableFrom(type);
    }

    public Map<String, String> convertFromText(String value, Class<?> targetType, String optionContext) {
        value = value.replace("\\,", ESCAPE_EXPRESSION);
        String[] values = StringUtils.commaDelimitedListToStringArray((String)value);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String v : values) {
            String[] keyValue = StringUtils.delimitedListToStringArray((String)v, (String)"=");
            if (keyValue.length != 2) {
                throw new RuntimeException("Input should be in a key=value comma separated format, e.g. key1=val1,key2=val2 etc.");
            }
            keyValue[1] = keyValue[1].replace(ESCAPE_EXPRESSION, ",");
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        return true;
    }
}

