/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.converters;

import java.util.ArrayList;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ListConverter
implements Converter<List<String>> {
    public boolean supports(Class<?> type, String optionContext) {
        return List.class.isAssignableFrom(type);
    }

    public List<String> convertFromText(String value, Class<?> targetType, String optionContext) {
        String[] values = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<String> list = new ArrayList<String>();
        for (String v : values) {
            list.add(v);
        }
        return list;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        return true;
    }
}

