/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli;

import io.cloudslang.lang.cli.SlangNamedProvider;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.BannerProvider;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SlangBanner
extends SlangNamedProvider
implements BannerProvider {
    private static final String BANNER = "slangBanner.txt";
    private static final String ASSISTANCE = "Welcome to CloudSlang. For assistance type help.";
    @Value(value="${slang.version}")
    private String slangVersion;

    public String getBanner() {
        StringBuilder sb = new StringBuilder();
        try (InputStream in = ClassLoader.getSystemResourceAsStream(BANNER);){
            sb.append(IOUtils.toString((InputStream)in));
        }
        catch (IOException e) {
            sb.append("CloudSlang");
        }
        sb.append(System.lineSeparator());
        sb.append(this.getVersion());
        return sb.toString();
    }

    public String getVersion() {
        return this.slangVersion;
    }

    public String getWelcomeMessage() {
        return ASSISTANCE;
    }
}

