/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.commons.services.impl;

import io.cloudslang.lang.commons.services.api.UserConfigurationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserConfigurationServiceImpl
implements UserConfigurationService {
    private static final String USER_CONFIG_DIR = "configuration";
    private static final String USER_CONFIG_FILENAME = "cslang.properties";
    private static final String USER_CONFIG_FILEPATH = "configuration" + File.separator + "cslang.properties";
    private static final String SUBSTITUTION_REGEX = "\\$\\{([^${}]+)\\}";
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{([^${}]+)\\}");

    @Override
    public void loadUserProperties() throws IOException {
        String appHome = System.getProperty("app.home");
        String propertyFilePath = appHome + File.separator + USER_CONFIG_FILEPATH;
        File propertyFile = new File(propertyFilePath);
        Properties rawProperties = new Properties();
        if (propertyFile.isFile()) {
            FileInputStream propertiesStream = new FileInputStream(propertyFilePath);
            Object object = null;
            try {
                rawProperties.load(propertiesStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (propertiesStream != null) {
                    if (object != null) {
                        try {
                            ((InputStream)propertiesStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)propertiesStream).close();
                    }
                }
            }
        }
        Set<Map.Entry<Object, Object>> propertyEntries = rawProperties.entrySet();
        for (Map.Entry<Object, Object> property : propertyEntries) {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            value = this.substitutePropertyReferences(value);
            System.setProperty(key, value);
        }
    }

    private String substitutePropertyReferences(String value) {
        Set<String> variableNames = this.findPropertyReferences(value);
        return this.replacePropertyReferences(value, variableNames);
    }

    private Set<String> findPropertyReferences(String value) {
        Matcher mather = SUBSTITUTION_PATTERN.matcher(value);
        HashSet<String> variableNames = new HashSet<String>();
        while (mather.find()) {
            variableNames.add(mather.group(1));
        }
        return variableNames;
    }

    private String replacePropertyReferences(String value, Set<String> variableNames) {
        for (String variableName : variableNames) {
            String variableValue = System.getProperty(variableName);
            if (!StringUtils.isNotEmpty((CharSequence)variableValue)) continue;
            value = value.replace("${" + variableName + "}", variableValue);
        }
        return value;
    }
}

