/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.ssh.services.actions;

import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import com.hp.oo.sdk.content.plugin.SessionResource;
import io.cloudslang.content.ssh.entities.KeyFile;
import io.cloudslang.content.ssh.entities.SSHConnection;
import io.cloudslang.content.ssh.entities.SSHShellInputs;
import io.cloudslang.content.ssh.services.SSHService;
import io.cloudslang.content.ssh.utils.CacheUtils;
import io.cloudslang.content.ssh.utils.StringUtils;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class SSHShellAbstract {
    public static final String COMMAND_IS_NOT_SPECIFIED_MESSAGE = "Command is not specified.";

    protected boolean addSecurityProvider() {
        boolean providerAdded = false;
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            providerAdded = true;
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        }
        return providerAdded;
    }

    protected void removeSecurityProvider() {
        Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
    }

    protected KeyFile getKeyFile(String privateKeyFile, String privateKeyPassPhrase) {
        KeyFile keyFile = null;
        if (privateKeyFile != null && !privateKeyFile.isEmpty()) {
            keyFile = privateKeyPassPhrase != null && !privateKeyPassPhrase.isEmpty() ? new KeyFile(privateKeyFile, privateKeyPassPhrase) : new KeyFile(privateKeyFile);
        }
        return keyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSHService getFromCache(SSHShellInputs sshShellInputs, String sessionId) {
        if (sessionId != null) {
            String string = sessionId;
            synchronized (string) {
                return CacheUtils.getFromCache((SessionResource<Map<String, SSHConnection>>)sshShellInputs.getSshGlobalSessionObject().getResource(), sessionId);
            }
        }
        return null;
    }

    protected boolean saveToCache(GlobalSessionObject<Map<String, SSHConnection>> sessionParam, SSHService service, String sessionId) {
        if (sessionParam.getName() == null) {
            sessionParam.setName("sshSessions:default-id");
        }
        return service.saveToCache(sessionParam, sessionId);
    }

    protected void populateResult(Map<String, String> returnResult, Throwable e) {
        returnResult.put("returnResult", e.getMessage());
        returnResult.put("exception", StringUtils.getStackTraceAsString(e));
        returnResult.put("returnCode", "-1");
    }
}

