/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.ssh.services.impl;

import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.cloudslang.content.ssh.entities.CommandResult;
import io.cloudslang.content.ssh.entities.ConnectionDetails;
import io.cloudslang.content.ssh.entities.KeyFile;
import io.cloudslang.content.ssh.entities.KnownHostsFile;
import io.cloudslang.content.ssh.entities.SSHConnection;
import io.cloudslang.content.ssh.services.SSHService;
import io.cloudslang.content.ssh.utils.CacheUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;

public class SSHServiceImpl
implements SSHService {
    private static final int POLLING_INTERVAL = 1000;
    private static final String SHELL_CHANNEL = "shell";
    private static final String KNOWN_HOSTS_ALLOW = "allow";
    private static final String KNOWN_HOSTS_STRICT = "strict";
    private static final String KNOWN_HOSTS_ADD = "add";
    private Session session;
    private Channel shellChannel;

    public SSHServiceImpl(Session session, Channel channel) {
        this.session = session;
        this.shellChannel = channel;
    }

    public SSHServiceImpl(ConnectionDetails details, KeyFile keyFile, KnownHostsFile knownHostsFile, int connectTimeout) {
        this(details, keyFile, knownHostsFile, connectTimeout, false);
    }

    public SSHServiceImpl(ConnectionDetails details, KeyFile keyFile, KnownHostsFile knownHostsFile, int connectTimeout, boolean keepContextForExpectCommand) {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(details.getUsername(), details.getHost(), details.getPort());
            String policy = knownHostsFile.getPolicy();
            Path knownHostsFilePath = knownHostsFile.getPath();
            switch (policy.toLowerCase(Locale.ENGLISH)) {
                case "allow": {
                    this.session.setConfig("StrictHostKeyChecking", "no");
                    break;
                }
                case "strict": {
                    jsch.setKnownHosts(knownHostsFilePath.toString());
                    this.session.setConfig("StrictHostKeyChecking", "yes");
                    break;
                }
                case "add": {
                    if (!knownHostsFilePath.isAbsolute()) {
                        throw new RuntimeException("The known_hosts file path should be absolute.");
                    }
                    if (!Files.exists(knownHostsFilePath, new LinkOption[0])) {
                        Files.createDirectories(knownHostsFilePath.getParent(), new FileAttribute[0]);
                        Files.createFile(knownHostsFilePath, new FileAttribute[0]);
                    }
                    jsch.setKnownHosts(knownHostsFilePath.toString());
                    this.session.setConfig("StrictHostKeyChecking", "no");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown known_hosts file policy.");
                }
            }
            if (keyFile == null) {
                this.session.setPassword(details.getPassword());
            } else {
                String keyFilePath = keyFile.getKeyFilePath();
                String passPhrase = keyFile.getPassPhrase();
                if (passPhrase != null) {
                    jsch.addIdentity(keyFilePath, passPhrase);
                } else {
                    jsch.addIdentity(keyFilePath);
                }
            }
            this.session.connect(connectTimeout);
            if (keepContextForExpectCommand) {
                this.shellChannel = this.session.openChannel(SHELL_CHANNEL);
                this.shellChannel.connect(connectTimeout);
            }
        }
        catch (JSchException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CommandResult runShellCommand(String command, String characterSet, boolean usePseudoTerminal, int connectTimeout, int commandTimeout, boolean agentForwarding) {
        try {
            Channel channel = this.session.openChannel(SHELL_CHANNEL);
            ((ChannelShell)channel).setPty(usePseudoTerminal);
            ((ChannelShell)channel).setAgentForwarding(agentForwarding);
            ByteArrayInputStream in = new ByteArrayInputStream(command.getBytes(characterSet));
            channel.setInputStream((InputStream)in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            channel.setOutputStream((OutputStream)out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            channel.setExtOutputStream((OutputStream)err);
            channel.connect(connectTimeout);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while (!channel.isEOF() && (commandTimeout -= 1000) > 0);
            CommandResult result = new CommandResult();
            result.setStandardOutput(out.toString(characterSet));
            result.setStandardError(err.toString(characterSet));
            channel.disconnect();
            result.setExitCode(channel.getExitStatus());
            return result;
        }
        catch (JSchException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createLocalTunnel(int localPort, String remoteHost, int remotePort) {
        try {
            this.session.setPortForwardingL(localPort, remoteHost, remotePort);
        }
        catch (JSchException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public void close() {
        if (this.shellChannel != null) {
            this.shellChannel.disconnect();
            this.shellChannel = null;
        }
        this.session.disconnect();
        this.session = null;
    }

    @Override
    public boolean saveToCache(GlobalSessionObject<Map<String, SSHConnection>> sessionParam, String sessionId) {
        return CacheUtils.saveSshSessionAndChannel(this.session, this.shellChannel, sessionParam, sessionId);
    }

    @Override
    public void removeFromCache(GlobalSessionObject<Map<String, SSHConnection>> sessionParam, String sessionId) {
        CacheUtils.removeSshSession(sessionParam, sessionId);
    }

    @Override
    public Session getSSHSession() {
        return this.session;
    }

    @Override
    public Channel getShellChannel() {
        return this.shellChannel;
    }
}

