/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.ssh.services.actions;

import io.cloudslang.content.ssh.entities.CommandResult;
import io.cloudslang.content.ssh.entities.ConnectionDetails;
import io.cloudslang.content.ssh.entities.KeyFile;
import io.cloudslang.content.ssh.entities.KnownHostsFile;
import io.cloudslang.content.ssh.entities.SSHShellInputs;
import io.cloudslang.content.ssh.services.SSHService;
import io.cloudslang.content.ssh.services.actions.SSHShellAbstract;
import io.cloudslang.content.ssh.services.impl.SSHServiceImpl;
import io.cloudslang.content.ssh.utils.Constants;
import io.cloudslang.content.ssh.utils.StringUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ScoreSSHShellCommand
extends SSHShellAbstract {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> execute(SSHShellInputs sshShellInputs) {
        HashMap<String, String> returnResult = new HashMap<String, String>();
        SSHService service = null;
        boolean providerAdded = this.addSecurityProvider();
        String sessionId = "";
        try {
            if (StringUtils.isEmpty(sshShellInputs.getCommand())) {
                throw new RuntimeException("Command is not specified.");
            }
            if (sshShellInputs.getArguments() != null) {
                sshShellInputs.setCommand(sshShellInputs.getCommand() + " " + sshShellInputs.getArguments());
            }
            int portNumber = StringUtils.toInt(sshShellInputs.getPort(), 22);
            String knownHostsPolicy = StringUtils.toNotEmptyString(sshShellInputs.getKnownHostsPolicy(), "allow");
            Path knownHostsPath = StringUtils.toPath(sshShellInputs.getKnownHostsPath(), Constants.DEFAULT_KNOWN_HOSTS_PATH);
            sessionId = "sshSession:" + sshShellInputs.getHost() + "-" + portNumber + "-" + sshShellInputs.getUsername();
            ConnectionDetails connection = new ConnectionDetails(sshShellInputs.getHost(), portNumber, sshShellInputs.getUsername(), sshShellInputs.getPassword());
            KeyFile keyFile = this.getKeyFile(sshShellInputs.getPrivateKeyFile(), sshShellInputs.getPassword());
            KnownHostsFile knownHostsFile = new KnownHostsFile(knownHostsPath, knownHostsPolicy);
            service = this.getSshServiceFromCache(sshShellInputs, sessionId);
            boolean saveSSHSession = false;
            if (service == null || !service.isConnected()) {
                saveSSHSession = true;
                service = new SSHServiceImpl(connection, keyFile, knownHostsFile, 10000);
            }
            this.runSSHCommand(sshShellInputs, returnResult, service, sessionId, saveSSHSession);
        }
        catch (Exception e) {
            if (service != null) {
                this.cleanupService(sshShellInputs, service, sessionId);
            }
            this.populateResult(returnResult, e);
        }
        finally {
            if (providerAdded) {
                this.removeSecurityProvider();
            }
        }
        return returnResult;
    }

    private SSHService getSshServiceFromCache(SSHShellInputs sshShellInputs, String sessionId) {
        SSHService service = this.getFromCache(sshShellInputs, sessionId);
        return service;
    }

    private void runSSHCommand(SSHShellInputs sshShellInputs, Map<String, String> returnResult, SSHService service, String sessionId, boolean saveSSHSession) {
        int timeoutNumber = StringUtils.toInt(sshShellInputs.getTimeout(), 90000);
        boolean usePseudoTerminal = StringUtils.toBoolean(sshShellInputs.getPty(), false);
        boolean agentForwarding = StringUtils.toBoolean(sshShellInputs.getAgentForwarding(), false);
        sshShellInputs.setCharacterSet(StringUtils.toNotEmptyString(sshShellInputs.getCharacterSet(), "UTF-8"));
        CommandResult commandResult = service.runShellCommand(sshShellInputs.getCommand(), sshShellInputs.getCharacterSet(), usePseudoTerminal, 10000, timeoutNumber, agentForwarding);
        this.handleSessionClosure(sshShellInputs, service, sessionId, saveSSHSession);
        this.populateResult(returnResult, commandResult);
    }

    private void handleSessionClosure(SSHShellInputs sshShellInputs, SSHService service, String sessionId, boolean saveSSHSession) {
        boolean saved;
        boolean closeSessionBoolean = StringUtils.toBoolean(sshShellInputs.getCloseSession(), false);
        if (closeSessionBoolean) {
            this.cleanupService(sshShellInputs, service, sessionId);
        } else if (saveSSHSession && !(saved = this.saveToCache(sshShellInputs.getSshGlobalSessionObject(), service, sessionId))) {
            throw new RuntimeException("The SSH session could not be saved in the given sessionParam.");
        }
    }

    protected void cleanupService(SSHShellInputs sshShellInputs, SSHService service, String sessionId) {
        service.close();
        service.removeFromCache(sshShellInputs.getSshGlobalSessionObject(), sessionId);
    }

    private void populateResult(Map<String, String> returnResult, CommandResult commandResult) {
        returnResult.put("STDERR", commandResult.getStandardError());
        returnResult.put("STDOUT", commandResult.getStandardOutput());
        if (commandResult.getExitCode() >= 0) {
            returnResult.put("returnResult", commandResult.getStandardOutput());
            returnResult.put("returnCode", "0");
        } else {
            returnResult.put("returnResult", commandResult.getStandardError());
            returnResult.put("returnCode", "-1");
        }
        returnResult.put("exitStatus", String.valueOf(commandResult.getExitCode()));
    }
}

