/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.ssh.utils;

import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import com.hp.oo.sdk.content.plugin.SessionResource;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Session;
import io.cloudslang.content.ssh.entities.SSHConnection;
import io.cloudslang.content.ssh.services.SSHService;
import io.cloudslang.content.ssh.services.impl.SSHServiceImpl;
import io.cloudslang.content.ssh.utils.SSHSessionResource;
import java.util.HashMap;
import java.util.Map;

public class CacheUtils {
    private static Session getSshSession(SessionResource<Map<String, SSHConnection>> resource, String sessionId) {
        SSHConnection sshConnection;
        Object obj;
        if (resource != null && (obj = resource.get()) != null && (sshConnection = (SSHConnection)((Map)obj).get(sessionId)) != null) {
            return sshConnection.getSession();
        }
        return null;
    }

    private static Channel getSshChannel(SessionResource<Map<String, SSHConnection>> resource, String sessionId) {
        SSHConnection sshConnection;
        Object obj;
        if (resource != null && (obj = resource.get()) != null && (sshConnection = (SSHConnection)((Map)obj).get(sessionId)) != null) {
            return sshConnection.getChannel();
        }
        return null;
    }

    public static boolean saveSshSessionAndChannel(Session session, Channel channel, GlobalSessionObject<Map<String, SSHConnection>> sessionParam, String sessionId) {
        SSHConnection sshConnection = channel != null ? new SSHConnection(session, channel) : new SSHConnection(session);
        if (sessionParam != null) {
            HashMap<String, SSHConnection> tempMap = (HashMap<String, SSHConnection>)sessionParam.get();
            if (tempMap == null) {
                tempMap = new HashMap<String, SSHConnection>();
            }
            tempMap.put(sessionId, sshConnection);
            sessionParam.setResource((SessionResource)new SSHSessionResource(tempMap));
            return true;
        }
        return false;
    }

    public static void removeSshSession(GlobalSessionObject<Map<String, SSHConnection>> sessionParam, String sessionId) {
        Map tempMap;
        SessionResource resource;
        if (sessionParam != null && (resource = sessionParam.getResource()) != null && (tempMap = (Map)resource.get()) != null) {
            tempMap.remove(sessionId);
        }
    }

    public static SSHService getFromCache(SessionResource<Map<String, SSHConnection>> sessionResource, String sessionId) {
        Session savedSession = CacheUtils.getSshSession(sessionResource, sessionId);
        if (savedSession != null && savedSession.isConnected()) {
            Channel savedChannel = CacheUtils.getSshChannel(sessionResource, sessionId);
            return new SSHServiceImpl(savedSession, savedChannel);
        }
        return null;
    }
}

