/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.ssh.actions;

import com.hp.oo.sdk.content.annotations.Action;
import com.hp.oo.sdk.content.annotations.Output;
import com.hp.oo.sdk.content.annotations.Param;
import com.hp.oo.sdk.content.annotations.Response;
import com.hp.oo.sdk.content.plugin.ActionMetadata.MatchType;
import com.hp.oo.sdk.content.plugin.ActionMetadata.ResponseType;
import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import io.cloudslang.content.ssh.entities.SSHConnection;
import io.cloudslang.content.ssh.entities.SSHShellInputs;
import io.cloudslang.content.ssh.services.actions.ScoreSSHShellCommand;
import java.util.Map;

public class SSHShellCommandAction {
    @Action(name="SSH Command", outputs={@Output(value="returnCode"), @Output(value="returnResult"), @Output(value="exception"), @Output(value="STDOUT"), @Output(value="STDERR")}, responses={@Response(text="success", field="returnCode", value="0", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.RESOLVED), @Response(text="failure", field="returnCode", value="-1", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.ERROR, isOnFail=true)})
    public Map<String, String> runSshShellCommand(@Param(value="host", required=true) String host, @Param(value="port") String port, @Param(value="username", required=true) String username, @Param(value="password", encrypted=true) String password, @Param(value="privateKeyFile") String privateKeyFile, @Param(value="knownHostsPolicy") String knownHostsPolicy, @Param(value="knownHostsPath") String knownHostsPath, @Param(value="command", required=true) String command, @Param(value="arguments", description="This input is deprecated, use the command input to provide arguments.") String arguments, @Param(value="characterSet") String characterSet, @Param(value="pty") String pty, @Param(value="agentForwarding") String agentForwarding, @Param(value="timeout") String timeout, @Param(value="sshSessions:default-id") GlobalSessionObject<Map<String, SSHConnection>> globalSessionObject, @Param(value="closeSession") String closeSession) {
        SSHShellInputs sshShellInputs = new SSHShellInputs();
        sshShellInputs.setHost(host);
        sshShellInputs.setPort(port);
        sshShellInputs.setUsername(username);
        sshShellInputs.setPassword(password);
        sshShellInputs.setPrivateKeyFile(privateKeyFile);
        sshShellInputs.setCommand(command);
        sshShellInputs.setArguments(arguments);
        sshShellInputs.setCharacterSet(characterSet);
        sshShellInputs.setPty(pty);
        sshShellInputs.setAgentForwarding(agentForwarding);
        sshShellInputs.setTimeout(timeout);
        sshShellInputs.setSshGlobalSessionObject(globalSessionObject);
        sshShellInputs.setCloseSession(closeSession);
        sshShellInputs.setKnownHostsPolicy(knownHostsPolicy);
        sshShellInputs.setKnownHostsPath(knownHostsPath);
        return new ScoreSSHShellCommand().execute(sshShellInputs);
    }
}

