/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.utils;

import io.cloudslang.content.httpclient.CSHttpClient;
import io.cloudslang.content.httpclient.HttpClientInputs;
import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import io.cloudslang.content.xml.entities.SimpleNamespaceContext;
import io.cloudslang.content.xml.entities.inputs.CommonInputs;
import io.cloudslang.content.xml.utils.DocumentUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final String OK_STATUS_CODE = "200";

    private XmlUtils() {
    }

    public static String nodeToString(Node node) throws TransformerException {
        if (node == null) {
            return "";
        }
        if (node.getNodeType() == 2) {
            return node.toString();
        }
        return XmlUtils.transformElementNode(node);
    }

    public static NamespaceContext getNamespaceContext(String xmlString, String xmlFilePath) throws Exception {
        InputStream inputXML = XmlUtils.getStream(xmlString, xmlFilePath);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(inputXML);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        while (reader.hasNext()) {
            QName qName;
            int evt = reader.next();
            if (evt != 1 || (qName = reader.getName()) == null || qName.getPrefix() == null || qName.getPrefix().compareTo("") == 0) continue;
            namespaces.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        return new SimpleNamespaceContext(namespaces);
    }

    public static Document parseXML(String xmlDocument, boolean secure) throws Exception {
        DocumentBuilder builder = XmlUtils.getDocumentBuilder(secure);
        return builder.parse(new InputSource(new StringReader(xmlDocument)));
    }

    public static DocumentBuilder getDocumentBuilder(boolean secure) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String feature = "http://xml.org/sax/features/external-general-entities";
        factory.setFeature(feature, false);
        feature = "http://xml.org/sax/features/external-parameter-entities";
        factory.setFeature(feature, false);
        feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        factory.setFeature(feature, false);
        feature = "http://apache.org/xml/features/disallow-doctype-decl";
        factory.setFeature(feature, true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", secure);
        return factory.newDocumentBuilder();
    }

    public static Document createDocumentFromFile(String path, boolean secure) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = XmlUtils.getDocumentBuilder(secure);
        File initialFile = new File(path);
        FileInputStream targetStream = new FileInputStream(initialFile);
        InputSource is = new InputSource(targetStream);
        return builder.parse(is);
    }

    public static Document createDocument(String xml, String filePath, String features) throws Exception {
        Document xmlDocument;
        try {
            InputStream inputXML = XmlUtils.getStream(xml, filePath);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            XmlUtils.setFeatures(builderFactory, features);
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            xmlDocument = builder.parse(inputXML);
        }
        catch (MalformedURLException e) {
            throw new Exception("Unable to open remote file requested, file path[" + filePath + "], error[" + e.getMessage() + "]", e);
        }
        catch (IOException e) {
            throw new Exception("Unable to open file requested, filename[" + filePath + "], error[" + e.getMessage() + "]", e);
        }
        return xmlDocument;
    }

    public static NodeList readNode(Document doc, String pathToNode, NamespaceContext ctx) throws XPathExpressionException {
        XPath xPath = XmlUtils.createXpath();
        xPath.setNamespaceContext(ctx);
        return (NodeList)xPath.evaluate(pathToNode, doc, XPathConstants.NODESET);
    }

    public static Node stringToNode(String value, String encoding, String features) throws Exception {
        Element node;
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes(encoding));){
            Document docNew = DocumentUtils.createDocumentBuilder(features).parse(inputStream);
            node = docNew.getDocumentElement();
        }
        catch (SAXException se) {
            throw new Exception("Value " + value + "is not valid XML element : " + se.getMessage());
        }
        return node;
    }

    private static XPath createXpath() {
        return XPathFactory.newInstance().newXPath();
    }

    private static InputStream getStream(String xml, String filePath) throws IOException {
        InputStream inputXML = StringUtils.isEmpty((CharSequence)filePath) ? new ByteArrayInputStream(xml.getBytes()) : (filePath.startsWith("http://") || filePath.startsWith("https://") ? new URL(filePath).openStream() : new FileInputStream(new File(filePath)));
        return inputXML;
    }

    public static StringWriter getStringWriter(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, streamResult);
        return writer;
    }

    public static NodeList evaluateXPathQuery(Document doc, NamespaceContext context, String xPathQuery) throws XPathExpressionException {
        XPathExpression expr = XmlUtils.createXPathExpression(context, xPathQuery);
        return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
    }

    public static XPathExpression createXPathExpression(NamespaceContext context, String xPathQuery) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(context);
        return xpath.compile(xPathQuery);
    }

    public static void validateNodeList(NodeList nodeList) throws Exception {
        if (nodeList.getLength() == 0) {
            throw new Exception("Element not found.");
        }
    }

    private static String transformElementNode(Node node) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString().trim();
    }

    public static Document getDocument(CommonInputs commonInputs) throws Exception {
        Document doc = "xmlPath".equalsIgnoreCase(commonInputs.getXmlDocumentSource()) ? XmlUtils.createDocumentFromFile(commonInputs.getXmlDocument(), commonInputs.getSecureProcessing()) : XmlUtils.parseXML(commonInputs.getXmlDocument(), commonInputs.getSecureProcessing());
        return doc;
    }

    public static NamespaceContext getNamespaceContext(CommonInputs commonInputs, Document doc) throws Exception {
        NamespaceContext context;
        if ("xmlPath".equalsIgnoreCase(commonInputs.getXmlDocumentSource())) {
            StringWriter writer = XmlUtils.getStringWriter(doc);
            context = XmlUtils.getNamespaceContext(writer.toString(), "");
        } else {
            context = XmlUtils.getNamespaceContext(commonInputs.getXmlDocument(), "");
        }
        return context;
    }

    public static String createXmlDocumentFromUrl(CommonInputs commonInputs) throws ParserConfigurationException, SAXException, IOException {
        CSHttpClient scoreHttpClient = new CSHttpClient();
        HttpClientInputs httpClientInputs = new HttpClientInputs();
        httpClientInputs.setMethod("GET");
        httpClientInputs.setUrl(commonInputs.getXmlDocument());
        if (commonInputs.getUsername().isEmpty()) {
            httpClientInputs.setAuthType("ANONYMOUS");
        } else {
            httpClientInputs.setAuthType(AuthTypes.BASIC);
            httpClientInputs.setUsername(commonInputs.getUsername());
            httpClientInputs.setPassword(commonInputs.getPassword());
        }
        httpClientInputs.setRequestCharacterSet(StandardCharsets.UTF_8.toString());
        httpClientInputs.setResponseCharacterSet(StandardCharsets.UTF_8.toString());
        httpClientInputs.setTrustAllRoots(commonInputs.getTrustAllRoots());
        httpClientInputs.setKeystore(commonInputs.getKeystore());
        httpClientInputs.setKeystorePassword(commonInputs.getKeystorePassword());
        httpClientInputs.setTrustKeystore(commonInputs.getTrustKeystore());
        httpClientInputs.setTrustPassword(commonInputs.getTrustPassword());
        httpClientInputs.setX509HostnameVerifier(commonInputs.getX509Hostnameverifier());
        httpClientInputs.setProxyHost(commonInputs.getProxyHost());
        httpClientInputs.setProxyPort(commonInputs.getProxyPort());
        httpClientInputs.setProxyUsername(commonInputs.getProxyUsername());
        httpClientInputs.setProxyPassword(commonInputs.getProxyPassword());
        Map requestResponse = scoreHttpClient.execute(httpClientInputs);
        if (!OK_STATUS_CODE.equals(requestResponse.get("statusCode"))) {
            throw new RuntimeException("Http request to specified URL: " + commonInputs.getXmlDocument() + " failed with status code: " + (String)requestResponse.get("statusCode") + ". Request response is: " + (String)requestResponse.get("returnResult"));
        }
        return (String)requestResponse.get("returnResult");
    }

    public static void setFeatures(DocumentBuilderFactory reader, String features) throws ParserConfigurationException {
        if (StringUtils.isNotBlank((CharSequence)features)) {
            Map<String, Boolean> featuresMap = XmlUtils.parseFeatures(features);
            Iterator<String> i$ = featuresMap.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String key = o = i$.next();
                reader.setFeature(key, featuresMap.get(key));
            }
        }
    }

    private static Map<String, Boolean> parseFeatures(String features) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String element : features.split("\\n")) {
            String[] keyValue = element.split("\\s");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Wrong format for 'features' input field!");
            }
            map.put(keyValue[0], Boolean.valueOf(keyValue[1]));
        }
        return map;
    }
}

