/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.utils;

import io.cloudslang.content.xml.entities.inputs.EditXmlInputs;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtils {
    public static void validateIsNotEmpty(String action, String message) throws Exception {
        if (action == null || StringUtils.isEmpty((CharSequence)action)) {
            throw new Exception(message);
        }
    }

    public static void validateXmlAndFilePathInputs(String xml, String filePath) throws Exception {
        if (StringUtils.isBlank((CharSequence)filePath) && StringUtils.isBlank((CharSequence)xml)) {
            throw new Exception("Supplied parameters: file path and xml is missing when one is required");
        }
        if (!StringUtils.isEmpty((CharSequence)filePath) && !StringUtils.isEmpty((CharSequence)xml)) {
            throw new Exception("Supplied parameters: file path and xml when only one is required");
        }
    }

    public static void validateInputs(EditXmlInputs inputs) throws Exception {
        ValidateUtils.validateXmlAndFilePathInputs(inputs.getXml(), inputs.getFilePath());
        if ("move".equals(inputs.getAction())) {
            ValidateUtils.validateIsNotEmpty(inputs.getXpath2(), "xpath2 input is required for action 'move' ");
        }
        if (!"subnode".equals(inputs.getAction()) && !"move".equals(inputs.getAction())) {
            ValidateUtils.validateIsNotEmpty(inputs.getType(), "type input is required for action '" + inputs.getAction() + "'");
            if (!("elem".equals(inputs.getType()) || "attr".equals(inputs.getType()) || "text".equals(inputs.getType()))) {
                throw new Exception("Invalid type. Only supported : elem, attr, text");
            }
            if ("attr".equals(inputs.getType())) {
                ValidateUtils.validateIsNotEmpty(inputs.getName(), "name input is required for type 'attr' ");
            }
        }
    }
}

