/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.utils;

import io.cloudslang.content.xml.utils.XmlUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class DocumentUtils {
    public static DocumentBuilder createDocumentBuilder(String features) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        XmlUtils.setFeatures(factory, features);
        factory.setNamespaceAware(false);
        return factory.newDocumentBuilder();
    }

    public static String documentToString(Document xmlDocument) throws IOException {
        String encoding = xmlDocument.getXmlEncoding() == null ? "UTF-8" : xmlDocument.getXmlEncoding();
        OutputFormat format = new OutputFormat(xmlDocument);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        format.setEncoding(encoding);
        try (StringWriter out = new StringWriter();){
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(xmlDocument);
            String string = ((Object)out).toString();
            return string;
        }
    }
}

