/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.services;

import io.cloudslang.content.xml.entities.inputs.CommonInputs;
import io.cloudslang.content.xml.entities.inputs.CustomInputs;
import io.cloudslang.content.xml.utils.ResultUtils;
import io.cloudslang.content.xml.utils.XmlUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpathQueryService {
    public Map<String, String> execute(CommonInputs commonInputs, CustomInputs customInputs) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Document doc = XmlUtils.getDocument(commonInputs);
            NamespaceContext context = XmlUtils.getNamespaceContext(commonInputs, doc);
            XPathExpression expr = XmlUtils.createXPathExpression(context, commonInputs.getXPathQuery());
            String selection = XpathQueryService.xPathQuery(doc, expr, customInputs.getQueryType(), customInputs.getDelimiter());
            if (StringUtils.isBlank((CharSequence)selection)) {
                ResultUtils.populateValueResult(result, "success", "XPath queried successfully.", "No match found", "0");
            } else {
                ResultUtils.populateValueResult(result, "success", "XPath queried successfully.", selection, "0");
            }
        }
        catch (Exception e) {
            ResultUtils.populateFailureResult(result, e.getMessage() + e);
        }
        return result;
    }

    private static String xPathQuery(Document doc, XPathExpression expr, String queryType, String delimiter) throws Exception {
        switch (queryType) {
            case "nodelist": {
                return XpathQueryService.xPathNodeListQuery(doc, expr, delimiter);
            }
            case "node": {
                return XpathQueryService.xPathNodeQuery(doc, expr);
            }
            case "value": {
                return XpathQueryService.xPathValueQuery(doc, expr);
            }
        }
        throw new Exception("Invalid query type");
    }

    private static String xPathNodeListQuery(Document doc, XPathExpression expr, String delimiter) throws Exception {
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        return XpathQueryService.nodeListToString(nodeList, delimiter);
    }

    private static String xPathNodeQuery(Document doc, XPathExpression expr) throws Exception {
        Node n = (Node)expr.evaluate(doc, XPathConstants.NODE);
        return XmlUtils.nodeToString(n);
    }

    private static String xPathValueQuery(Document doc, XPathExpression expr) throws Exception {
        return (String)expr.evaluate(doc, XPathConstants.STRING);
    }

    private static String nodeListToString(NodeList nodeList, String delimiter) throws TransformerException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodeList.getLength() - 1; ++i) {
            sb.append(XmlUtils.nodeToString(nodeList.item(i)));
            sb.append(delimiter);
        }
        sb.append(XmlUtils.nodeToString(nodeList.item(nodeList.getLength() - 1)));
        return sb.toString();
    }
}

