/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.services;

import io.cloudslang.content.xml.entities.inputs.CommonInputs;
import io.cloudslang.content.xml.entities.inputs.CustomInputs;
import io.cloudslang.content.xml.utils.ResultUtils;
import io.cloudslang.content.xml.utils.XmlUtils;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateService {
    public Map<String, String> execute(CommonInputs commonInputs, CustomInputs customInputs) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String xsdDocument;
            String xmlDocument;
            Document doc;
            if ("xmlPath".equalsIgnoreCase(commonInputs.getXmlDocumentSource())) {
                doc = XmlUtils.createDocumentFromFile(commonInputs.getXmlDocument(), commonInputs.getSecureProcessing());
                xmlDocument = ValidateService.getStringValueOfDocument(doc);
            } else if ("xmlUrl".equalsIgnoreCase(commonInputs.getXmlDocumentSource())) {
                xmlDocument = XmlUtils.createXmlDocumentFromUrl(commonInputs);
                xmlDocument = xmlDocument.replaceAll("<!DOCTYPE[^>]*>\n", "");
            } else {
                xmlDocument = commonInputs.getXmlDocument();
            }
            if ("xsdPath".equalsIgnoreCase(customInputs.getXsdDocumentSource())) {
                doc = XmlUtils.createDocumentFromFile(customInputs.getXsdDocument(), commonInputs.getSecureProcessing());
                xsdDocument = ValidateService.getStringValueOfDocument(doc);
            } else {
                xsdDocument = customInputs.getXsdDocument();
            }
            XmlUtils.parseXML(xmlDocument, commonInputs.getSecureProcessing());
            result.put("returnResult", "Parsing successful.");
            if (StringUtils.isNotBlank((CharSequence)xsdDocument)) {
                ValidateService.validateAgainstXsd(xmlDocument, xsdDocument);
                result.put("returnResult", "XML is valid.");
            }
            result.put("result", "success");
            result.put("returnCode", "0");
            result.put("errorMessage", "");
        }
        catch (SAXParseException e) {
            ResultUtils.populateFailureResult(result, "Parsing error: " + e.getMessage());
        }
        catch (SAXException e) {
            ResultUtils.populateFailureResult(result, "Validation failed: " + e.getMessage());
        }
        catch (Exception e) {
            ResultUtils.populateFailureResult(result, e.getMessage());
        }
        return result;
    }

    private static String getStringValueOfDocument(Document doc) throws TransformerException {
        return XmlUtils.getStringWriter(doc).toString();
    }

    private static void validateAgainstXsd(String xmlDocument, String xsdDocument) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(new StringReader(xsdDocument)));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(new StringReader(xmlDocument)));
    }
}

