/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.services;

import io.cloudslang.content.xml.entities.inputs.CommonInputs;
import io.cloudslang.content.xml.entities.inputs.CustomInputs;
import io.cloudslang.content.xml.utils.ResultUtils;
import io.cloudslang.content.xml.utils.XmlUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoveService {
    public Map<String, String> execute(CommonInputs commonInputs, CustomInputs customInputs) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Document doc = XmlUtils.getDocument(commonInputs);
            NamespaceContext context = XmlUtils.getNamespaceContext(commonInputs, doc);
            NodeList nodeList = XmlUtils.evaluateXPathQuery(doc, context, commonInputs.getXPathQuery());
            XmlUtils.validateNodeList(nodeList);
            RemoveService.removeFromNodeList(nodeList, customInputs.getAttributeName());
            ResultUtils.populateSuccessResult(result, "Removed successfully.", XmlUtils.nodeToString(doc));
        }
        catch (XPathExpressionException e) {
            ResultUtils.populateFailureResult(result, "XPath parsing error: " + e.getMessage());
        }
        catch (TransformerException te) {
            ResultUtils.populateFailureResult(result, "Transformer error: " + te.getMessage());
        }
        return result;
    }

    private static void removeFromNodeList(NodeList nodeList, String attributeName) throws Exception {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) {
                throw new Exception("Removal failed: XPath must return element types.");
            }
            if (StringUtils.isBlank((CharSequence)attributeName)) {
                node.getParentNode().removeChild(node);
                continue;
            }
            node.getAttributes().removeNamedItem(attributeName);
        }
    }
}

