/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.services;

import io.cloudslang.content.xml.entities.inputs.CommonInputs;
import io.cloudslang.content.xml.entities.inputs.CustomInputs;
import io.cloudslang.content.xml.utils.ResultUtils;
import io.cloudslang.content.xml.utils.XmlUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertBeforeService {
    public Map<String, String> execute(CommonInputs commonInputs, CustomInputs customInputs) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Document doc = XmlUtils.getDocument(commonInputs);
            NamespaceContext context = XmlUtils.getNamespaceContext(commonInputs, doc);
            Document beforeDoc = XmlUtils.parseXML(customInputs.getXmlElement(), commonInputs.getSecureProcessing());
            Node beforeNode = doc.importNode(beforeDoc.getDocumentElement(), true);
            NodeList nodeList = XmlUtils.evaluateXPathQuery(doc, context, commonInputs.getXPathQuery());
            XmlUtils.validateNodeList(nodeList);
            InsertBeforeService.insertBeforeToNodeList(nodeList, beforeNode);
            ResultUtils.populateSuccessResult(result, "Inserted before successfully.", XmlUtils.nodeToString(doc));
        }
        catch (XPathExpressionException e) {
            ResultUtils.populateFailureResult(result, "XPath parsing error: " + e.getMessage());
        }
        catch (TransformerException te) {
            ResultUtils.populateFailureResult(result, "Transformer error: " + te.getMessage());
        }
        catch (Exception e) {
            ResultUtils.populateFailureResult(result, "Parsing error: " + e.getMessage());
        }
        return result;
    }

    private static void insertBeforeToNodeList(NodeList nodeList, Node beforeNode) throws Exception {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) {
                throw new Exception("Insert failed: XPath must return element types.");
            }
            node.getParentNode().insertBefore(beforeNode.cloneNode(true), node);
        }
    }
}

