/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.entities.inputs;

import io.cloudslang.content.xml.utils.ValidateUtils;

public class EditXmlInputs {
    private String xml;
    private String filePath;
    private String action;
    private String xpath1;
    private String xpath2;
    private String type;
    private String name;
    private String value;
    private String parsingFeatures;

    public EditXmlInputs(EditXmlInputsBuilder builder) {
        this.xml = builder.xml;
        this.filePath = builder.filePath;
        this.action = builder.action;
        this.xpath1 = builder.xpath1;
        this.xpath2 = builder.xpath2;
        this.type = builder.type;
        this.name = builder.name;
        this.value = builder.value;
        this.parsingFeatures = builder.parsingFeatures;
    }

    public String getXml() {
        return this.xml;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAction() {
        return this.action;
    }

    public String getXpath1() {
        return this.xpath1;
    }

    public String getXpath2() {
        return this.xpath2;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getParsingFeatures() {
        return this.parsingFeatures;
    }

    public static class EditXmlInputsBuilder {
        private String xml;
        private String filePath;
        private String action;
        private String xpath1;
        private String xpath2;
        private String type;
        private String name;
        private String value;
        private String parsingFeatures;

        public EditXmlInputs build() {
            return new EditXmlInputs(this);
        }

        public EditXmlInputsBuilder withXml(String inputValue) {
            this.xml = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withFilePath(String inputValue) {
            this.filePath = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withAction(String inputValue) throws Exception {
            ValidateUtils.validateIsNotEmpty(inputValue, "action input is required.");
            this.action = inputValue.toLowerCase();
            return this;
        }

        public EditXmlInputsBuilder withXpath1(String inputValue) throws Exception {
            ValidateUtils.validateIsNotEmpty(inputValue, "xpath1 input is required.");
            this.xpath1 = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withType(String inputValue) {
            this.type = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withName(String inputValue) {
            this.name = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withValue(String inputValue) {
            this.value = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withXpath2(String inputValue) {
            this.xpath2 = inputValue;
            return this;
        }

        public EditXmlInputsBuilder withParsingFeatures(String inputValue) {
            this.parsingFeatures = inputValue;
            return this;
        }
    }
}

