/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.xml.entities.inputs;

import io.cloudslang.content.xml.utils.InputUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomInputs {
    private String attributeName;
    private String value;
    private String xmlElement;
    private String xsdDocument;
    private String xsdDocumentSource;
    private String queryType;
    private String delimiter;

    public CustomInputs(CustomInputsBuilder builder) {
        this.attributeName = builder.attributeName;
        this.value = builder.value;
        this.xmlElement = builder.xmlElement;
        this.xsdDocument = builder.xsdDocument;
        this.xsdDocumentSource = builder.xsdDocumentSource;
        this.queryType = builder.queryType;
        this.delimiter = builder.delimiter;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getValue() {
        return this.value;
    }

    public String getXmlElement() {
        return this.xmlElement;
    }

    public String getXsdDocument() {
        return this.xsdDocument;
    }

    public String getXsdDocumentSource() {
        return this.xsdDocumentSource;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public static class CustomInputsBuilder {
        private String attributeName;
        private String value;
        private String xmlElement;
        private String xsdDocument;
        private String xsdDocumentSource;
        private String queryType;
        private String delimiter;

        public CustomInputs build() {
            return new CustomInputs(this);
        }

        public CustomInputsBuilder withAttributeName(String inputValue) {
            this.attributeName = inputValue;
            return this;
        }

        public CustomInputsBuilder withValue(String inputValue) {
            this.value = inputValue;
            return this;
        }

        public CustomInputsBuilder withXmlElement(String inputValue) {
            this.xmlElement = inputValue;
            return this;
        }

        public CustomInputsBuilder withXsdDocument(String inputValue) {
            this.xsdDocument = inputValue;
            return this;
        }

        public CustomInputsBuilder withQueryType(String inputValue) {
            this.queryType = inputValue;
            return this;
        }

        public CustomInputsBuilder withDelimiter(String inputValue) {
            this.delimiter = StringUtils.isBlank((CharSequence)inputValue) ? "," : inputValue;
            return this;
        }

        public CustomInputsBuilder withXsdDocumentSource(String xsdDocumentSource) {
            this.xsdDocumentSource = InputUtils.validateXsdDocumentSource(xsdDocumentSource);
            return this;
        }
    }
}

