/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.utils;

import io.cloudslang.content.utils.BooleanUtilities;
import io.cloudslang.content.utils.NumberUtilities;
import io.cloudslang.content.utils.OtherUtilities;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Validator {
    private final List<String> validationErrorList = new ArrayList<String>();

    public List<String> getValidationErrorList() {
        return this.validationErrorList;
    }

    public void validatePort(@NotNull String port) {
        if (!OtherUtilities.isValidIpPort((String)port)) {
            this.validationErrorList.add("Invalid port value!");
        }
    }

    public void validateProtocol(String protocol) {
        if (!"https".equalsIgnoreCase(protocol) && !"http".equalsIgnoreCase(protocol)) {
            this.validationErrorList.add("Invalid protocol. Valid values: 'http' and 'https'.");
        }
    }

    public void validateInt(@NotNull String intValue) {
        if (!NumberUtilities.isValidInt((String)intValue)) {
            this.validationErrorList.add("Invalid integer.");
        }
    }

    public void validateBoolean(@NotNull String booleanValue) {
        if (!BooleanUtilities.isValid((String)booleanValue)) {
            this.validationErrorList.add("Invalid boolean.");
        }
    }

    @SafeVarargs
    public final void validateSameLength(List<String> ... args) {
        if (args.length < 1) {
            return;
        }
        List<String> firstList = args[0];
        for (List<String> list : args) {
            if (list.size() == firstList.size()) continue;
            this.validationErrorList.add("Lists are of not equal size!");
        }
    }
}

