/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.utils;

import io.cloudslang.content.dca.models.DcaAuthModel;
import io.cloudslang.content.httpclient.HttpClientInputs;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

public class Utilities {
    @NotNull
    public static String getIdmUrl(@NotNull String protocol, @NotNull String idmHostInp, @NotNull String idmPort) {
        URIBuilder uriBuilder = Utilities.getUriBuilder(protocol, idmHostInp, idmPort);
        uriBuilder.setPath("/idm-service/v2.0/tokens");
        try {
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String getDcaDeployUrl(@NotNull String protocol, @NotNull String dcaHost, @NotNull String dcaPort) {
        URIBuilder uriBuilder = Utilities.getUriBuilder(protocol, dcaHost, dcaPort);
        uriBuilder.setPath("/urest/v1/deployment");
        try {
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String getDcaDeploymentUrl(@NotNull String protocol, @NotNull String dcaHost, @NotNull String dcaPort, @NotNull String deploymentUuid) {
        URIBuilder uriBuilder = Utilities.getUriBuilder(protocol, dcaHost, dcaPort);
        uriBuilder.setPath(String.format("%s/%s", "/urest/v1/deployment", deploymentUuid));
        try {
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static URIBuilder getUriBuilder(@NotNull String protocol, @NotNull String dcaHost, @NotNull String dcaPort) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(dcaHost);
        uriBuilder.setPort(Integer.valueOf(dcaPort).intValue());
        uriBuilder.setScheme(protocol);
        return uriBuilder;
    }

    public static void setProxy(@NotNull HttpClientInputs httpClientInputs, @NotNull String proxyHost, @NotNull String proxyPort, @NotNull String proxyUsername, @NotNull String proxyPassword) {
        httpClientInputs.setProxyHost(proxyHost);
        httpClientInputs.setProxyPort(proxyPort);
        httpClientInputs.setProxyUsername(proxyUsername);
        httpClientInputs.setProxyPassword(proxyPassword);
    }

    public static void setSecurityInputs(@NotNull HttpClientInputs httpClientInputs, @NotNull String trustAllRoots, @NotNull String x509HostnameVerifier, @NotNull String trustKeystore, @NotNull String trustPassword, @NotNull String keystore, @NotNull String keystorePassword) {
        httpClientInputs.setTrustAllRoots(trustAllRoots);
        httpClientInputs.setX509HostnameVerifier(x509HostnameVerifier);
        httpClientInputs.setTrustKeystore(trustKeystore);
        httpClientInputs.setTrustPassword(trustPassword);
        httpClientInputs.setKeystore(keystore);
        httpClientInputs.setKeystorePassword(keystorePassword);
    }

    public static void setDcaCredentials(@NotNull HttpClientInputs httpClientInputs, @NotNull String dcaUsername, @NotNull String dcaPassword, @NotNull String dcaTenant) {
        DcaAuthModel dcaAuthModel = new DcaAuthModel(dcaTenant);
        dcaAuthModel.setCredentials(dcaUsername, dcaPassword);
        httpClientInputs.setBody(dcaAuthModel.toJson());
        httpClientInputs.setPreemptiveAuth("true");
    }

    public static void setIdmAuthentication(@NotNull HttpClientInputs httpClientInputs, @NotNull String authType, @NotNull String idmUsername, @NotNull String idmPassword, @NotNull String preemptiveAuth) {
        httpClientInputs.setAuthType(authType);
        httpClientInputs.setPreemptiveAuth(preemptiveAuth);
        httpClientInputs.setUsername(idmUsername);
        httpClientInputs.setPassword(idmPassword);
    }

    public static void setConnectionParameters(HttpClientInputs httpClientInputs, @NotNull String connectTimeout, @NotNull String socketTimeout, @NotNull String useCookies, @NotNull String keepAlive, @NotNull String connectionsMaxPerRoot, @NotNull String connectionsMaxTotal) {
        httpClientInputs.setConnectTimeout(connectTimeout);
        httpClientInputs.setSocketTimeout(socketTimeout);
        httpClientInputs.setUseCookies(useCookies);
        httpClientInputs.setKeepAlive(keepAlive);
        httpClientInputs.setConnectionsMaxPerRoute(connectionsMaxPerRoot);
        httpClientInputs.setConnectionsMaxTotal(connectionsMaxTotal);
    }

    @NotNull
    public static List<String> splitToList(@NotNull String string, @NotNull String delimiter) {
        return Arrays.asList(StringUtils.splitPreserveAllTokens((String)string, (String)delimiter));
    }

    @NotNull
    public static String getAuthHeaders(@NotNull String authToken, @NotNull String refreshToken) {
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append("X-Auth-Token:").append(authToken).append("\r\n");
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            headerBuilder.append("Refresh-Token:").append(refreshToken).append("\r\n");
        }
        return headerBuilder.toString();
    }
}

