/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudslang.content.dca.models.DcaBaseResourceModel;
import io.cloudslang.content.dca.models.DcaDeploymentParameterModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DcaResourceModel {
    private String typeUuid;
    private int deploySequence;
    private List<DcaBaseResourceModel> baseResources = new ArrayList<DcaBaseResourceModel>();
    private List<DcaDeploymentParameterModel> deploymentParameters = new ArrayList<DcaDeploymentParameterModel>();

    public DcaResourceModel() {
    }

    public DcaResourceModel(String typeUuid, int deploySequence) {
        this.typeUuid = typeUuid;
        this.deploySequence = deploySequence;
    }

    public void addBaseResource(@NotNull DcaBaseResourceModel baseResource) {
        this.baseResources.add(baseResource);
    }

    public void addBaseResources(@NotNull List<DcaBaseResourceModel> baseResourceList) {
        this.baseResources.addAll(baseResourceList);
    }

    public void addDeploymentParameter(@NotNull DcaDeploymentParameterModel deploymentParameter) {
        this.deploymentParameters.add(deploymentParameter);
    }

    public void addDeploymentParameters(@NotNull List<DcaDeploymentParameterModel> deploymentParameterList) {
        this.deploymentParameters.addAll(deploymentParameterList);
    }

    @JsonProperty(value="TypeUuid")
    public String getTypeUuid() {
        return this.typeUuid;
    }

    public void setTypeUuid(String typeUuid) {
        this.typeUuid = typeUuid;
    }

    public int getDeploySequence() {
        return this.deploySequence;
    }

    public void setDeploySequence(int deploySequence) {
        this.deploySequence = deploySequence;
    }

    public List<DcaBaseResourceModel> getBaseResources() {
        return this.baseResources;
    }

    public void setBaseResources(List<DcaBaseResourceModel> baseResources) {
        this.baseResources = baseResources;
    }

    public List<DcaDeploymentParameterModel> getDeploymentParameters() {
        return this.deploymentParameters;
    }

    public void setDeploymentParameters(List<DcaDeploymentParameterModel> deploymentParameters) {
        this.deploymentParameters = deploymentParameters;
    }

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

