/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.actions.utils;

import com.hp.oo.sdk.content.annotations.Action;
import com.hp.oo.sdk.content.annotations.Output;
import com.hp.oo.sdk.content.annotations.Param;
import com.hp.oo.sdk.content.annotations.Response;
import com.hp.oo.sdk.content.plugin.ActionMetadata.MatchType;
import com.hp.oo.sdk.content.plugin.ActionMetadata.ResponseType;
import io.cloudslang.content.dca.controllers.CreateResourceJSONController;
import io.cloudslang.content.dca.models.DcaResourceModel;
import io.cloudslang.content.dca.utils.Utilities;
import io.cloudslang.content.dca.utils.Validator;
import io.cloudslang.content.utils.OutputUtilities;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CreateResourceJSON {
    @Action(name="Create Resource JSON", description="This utility operation is used to create a JSON representation of a DCA resource for use in the Deploy Template operation.", outputs={@Output(value="returnResult", description="A JSON representation of a DCA Resource, to use in the Deploy Template Operation."), @Output(value="returnCode", description="The return code of the operation, 0 in case of success, -1 in case of failure"), @Output(value="exception", description="In case of failure, the error message, otherwise empty.")}, responses={@Response(text="success", field="returnCode", value="0", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.RESOLVED, description="Operation succeeded, returnCode is '0'."), @Response(text="failure", field="returnCode", value="-1", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.ERROR, description="Operation failed, returnCode is '-1'.")})
    public Map<String, String> execute(@Param(value="typeUuid", required=true, description="The UUID of the resource type.") String typeUuid, @Param(value="deploySequence", required=true, description="A number (starting at 1) representing at which step the resource deployment should occur.") String deploySequence, @Param(value="baseResourceUuidList", required=true, description="The list of base resource UUIDs from uCMDB.") String baseResourceUuidList, @Param(value="baseResourceCiTypeList", required=true, description="The list of uCMDB ciTypes of the base resources.") String baseResourceCiTypeList, @Param(value="baseResourceTypeUuidList", required=true, description="The list of resource type UUIDs for the base resources.") String baseResourceTypeUuidList, @Param(value="deploymentParameterNameList", description="List of deployment parameter names.") String deploymentParameterNameList, @Param(value="deploymentParameterValueList", description="List of deployment parameter values.") String deploymentParameterValueList, @Param(value="delimiter", description="The delimiter used in the above lists.") String delimiterInp) {
        String delimiter = (String)StringUtils.defaultIfEmpty((CharSequence)delimiterInp, (CharSequence)",");
        List<String> baseResourceUUIDs = Utilities.splitToList(baseResourceUuidList, delimiter);
        List<String> baseResourceCiTypes = Utilities.splitToList(baseResourceCiTypeList, delimiter);
        List<String> baseResourceTypeUUIDs = Utilities.splitToList(baseResourceTypeUuidList, delimiter);
        List<String> deploymentParameterNames = Utilities.splitToList(deploymentParameterNameList, delimiter);
        List<String> deploymentParameterValues = Utilities.splitToList(deploymentParameterValueList, delimiter);
        Validator validator = new Validator();
        validator.validateInt(deploySequence);
        validator.validateSameLength(baseResourceUUIDs, baseResourceCiTypes, baseResourceTypeUUIDs);
        validator.validateSameLength(deploymentParameterNames, deploymentParameterValues);
        if (!validator.getValidationErrorList().isEmpty()) {
            return OutputUtilities.getFailureResultsMap((String)StringUtils.join(validator.getValidationErrorList(), (String)System.lineSeparator()));
        }
        DcaResourceModel dcaResourceModel = new DcaResourceModel(typeUuid, Integer.valueOf(deploySequence));
        dcaResourceModel.addBaseResources(CreateResourceJSONController.getDcaBaseResourceModels(baseResourceUUIDs, baseResourceCiTypes, baseResourceTypeUUIDs));
        dcaResourceModel.addDeploymentParameters(CreateResourceJSONController.getDcaDeploymentParameterModels(deploymentParameterNames, deploymentParameterValues));
        try {
            return OutputUtilities.getSuccessResultsMap((String)dcaResourceModel.toJson());
        }
        catch (Exception e) {
            return OutputUtilities.getFailureResultsMap((Throwable)e);
        }
    }
}

