/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.actions.templates;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.oo.sdk.content.annotations.Action;
import com.hp.oo.sdk.content.annotations.Output;
import com.hp.oo.sdk.content.annotations.Param;
import com.hp.oo.sdk.content.annotations.Response;
import com.hp.oo.sdk.content.plugin.ActionMetadata.MatchType;
import com.hp.oo.sdk.content.plugin.ActionMetadata.ResponseType;
import io.cloudslang.content.dca.actions.templates.GetDeployment;
import io.cloudslang.content.dca.models.DcaDeploymentModel;
import io.cloudslang.content.dca.models.DcaResourceModel;
import io.cloudslang.content.dca.utils.DefaultValues;
import io.cloudslang.content.dca.utils.Utilities;
import io.cloudslang.content.dca.utils.Validator;
import io.cloudslang.content.httpclient.CSHttpClient;
import io.cloudslang.content.httpclient.HttpClientInputs;
import io.cloudslang.content.utils.BooleanUtilities;
import io.cloudslang.content.utils.OutputUtilities;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;

public class DeployTemplate {
    @Action(name="Deploy Template", description="This operation can be used to deploy a DCA template.", outputs={@Output(value="returnResult", description="In case of success, a JSON representation of the deployment, otherwise an error message."), @Output(value="returnCode", description="The return code of the operation, 0 in case of success, -1 in case of failure"), @Output(value="exception", description="In case of failure, the error message, otherwise empty."), @Output(value="status", description="The status of the deployment.")}, responses={@Response(text="success", field="returnCode", value="0", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.RESOLVED, description="Operation succeeded, returnCode is '0'."), @Response(text="failure", field="returnCode", value="-1", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.ERROR, description="Operation failed, returnCode is '-1'.")})
    public Map<String, String> execute(@Param(value="dcaHost", required=true, description="The hostname or IP of the DCA environment.") String host, @Param(value="dcaPort", description="The port on which the DCA environment is listening.") String portInp, @Param(value="protocol", description="The protocol with which to connect to the DCA environment") String protocolInp, @Param(value="authToken", required=true, encrypted=true, description="The authentication token from the Get Authentication Token operation.") String authToken, @Param(value="refreshToken", encrypted=true, description="The refresh token from the Get Authentication Token operation. This can be used to extend the default lifetime of the authentication token.") String refreshToken, @Param(value="deploymentName", required=true, description="The display name of the deployment.") String deploymentName, @Param(value="deploymentDescription", description="A description of the deployment.") String deploymentDesc, @Param(value="deploymentTemplateId", required=true, description="The UUID of the DCA template to deploy.") String deploymentTemplateId, @Param(value="deploymentResourcesJson", required=true, description="The JSON array with resources resulted from the Create Resource JSON operation.") String deploymentResources, @Param(value="async", description="Whether to run the operation is async mode. In async mode, the deployment will be started, and the operation will exit. Otherwise the operation will wait for the result of the deployment.") String asyncInp, @Param(value="timeout", description="The timeout in seconds, in case the operation runs in sync mode.") String timeoutInp, @Param(value="pollingInterval", description="The interval in seconds at which the deployment will be queried in sync mode.") String pollingIntervalInp, @Param(value="proxyHost", description="The proxy server used to access the web site.") String proxyHost, @Param(value="proxyPort", description="The proxy server port. Default value: 8080. Valid values: -1 and integer values greater than 0. The value '-1' indicates that the proxy port is not set and the protocol default port will be used. If the protocol is 'http' and the 'proxyPort' is set to '-1' then port '80' will be used.") String proxyPort, @Param(value="proxyUsername", description="The user name used when connecting to the proxy.") String proxyUsername, @Param(value="proxyPassword", encrypted=true, description="The proxy server password associated with the proxyUsername input value.") String proxyPassword, @Param(value="trustAllRoots", description="Specifies whether to enable weak security over SSL/TSL. A certificate is trusted even if no trusted certification authority issued it.") String trustAllRoots, @Param(value="x509HostnameVerifier", description="Specifies the way the server hostname must match a domain name in the subject's Common Name (CN) or subjectAltName field of the X.509 certificate. Set this to \"allow_all\" to skip any checking. For the value \"browser_compatible\" the hostname verifier works the same way as Curl and Firefox. The hostname must match either the first CN, or any of the subject-alts. A wildcard can occur in the CN, and in any of the subject-alts. The only difference between \"browser_compatible\" and \"strict\" is that a wildcard (such as \"*.foo.com\") with \"browser_compatible\" matches all subdomains, including \"a.b.foo.com\".") String x509HostnameVerifier, @Param(value="trustKeystore", description="The pathname of the Java TrustStore file. This contains certificates from other parties that you expect to communicate with, or from Certificate Authorities that you trust to identify other parties.  If the protocol (specified by the 'url') is not 'https' or if trustAllRoots is 'true' this input is ignored. Format: Java KeyStore (JKS)") String trustKeystoreInp, @Param(value="trustPassword", encrypted=true, description="The password associated with the TrustStore file. If trustAllRoots is false and trustKeystore is empty, trustPassword default will be supplied.") String trustPasswordInp, @Param(value="keystore", description="The pathname of the Java KeyStore file. You only need this if the server requires client authentication. If the protocol (specified by the 'url') is not 'https' or if trustAllRoots is 'true' this input is ignored. Format: Java KeyStore (JKS)") String keystoreInp, @Param(value="keystorePassword", encrypted=true, description="The password associated with the KeyStore file. If trustAllRoots is false and keystore is empty, keystorePassword default will be supplied.") String keystorePasswordInp, @Param(value="connectTimeout", description="The time to wait for a connection to be established, in seconds. A timeout value of '0' represents an infinite timeout.") String connectTimeout, @Param(value="socketTimeout", description="The timeout for waiting for data (a maximum period inactivity between two consecutive data packets), in seconds. A socketTimeout value of '0' represents an infinite timeout.") String socketTimeout, @Param(value="useCookies", description="Specifies whether to enable cookie tracking or not. Cookies are stored between consecutive calls in a serializable session object therefore they will be available on a branch level. If you specify a non-boolean value, the default value is used.") String useCookies, @Param(value="keepAlive", description="Specifies whether to create a shared connection that will be used in subsequent calls. If keepAlive is false, the already open connection will be used and after execution it will close it.") String keepAlive, @Param(value="connectionsMaxPerRoute", description="The maximum limit of connections on a per route basis.") String connectionsMaxPerRoot, @Param(value="connectionsMaxTotal", description="The maximum limit of connections in total.") String connectionsMaxTotal) {
        String port = (String)StringUtils.defaultIfEmpty((CharSequence)portInp, (CharSequence)"443");
        String protocol = (String)StringUtils.defaultIfEmpty((CharSequence)protocolInp, (CharSequence)"https");
        String asyncStr = (String)StringUtils.defaultIfEmpty((CharSequence)asyncInp, (CharSequence)"true");
        String timeoutStr = (String)StringUtils.defaultIfEmpty((CharSequence)timeoutInp, (CharSequence)"1200");
        String pollingIntervalStr = (String)StringUtils.defaultIfEmpty((CharSequence)pollingIntervalInp, (CharSequence)"30");
        String trustKeystore = (String)StringUtils.defaultIfEmpty((CharSequence)trustKeystoreInp, (CharSequence)DefaultValues.DEFAULT_JAVA_KEYSTORE);
        String trustPassword = (String)StringUtils.defaultIfEmpty((CharSequence)trustPasswordInp, (CharSequence)"changeit");
        String keystore = (String)StringUtils.defaultIfEmpty((CharSequence)keystoreInp, (CharSequence)DefaultValues.DEFAULT_JAVA_KEYSTORE);
        String keystorePassword = (String)StringUtils.defaultIfEmpty((CharSequence)keystorePasswordInp, (CharSequence)"changeit");
        Validator validator = new Validator();
        validator.validatePort(port);
        validator.validateProtocol(protocol);
        validator.validateBoolean(asyncStr);
        validator.validateInt(timeoutStr);
        validator.validateInt(pollingIntervalStr);
        if (!validator.getValidationErrorList().isEmpty()) {
            return OutputUtilities.getFailureResultsMap((String)StringUtils.join(validator.getValidationErrorList(), (String)System.lineSeparator()));
        }
        HttpClientInputs httpClientInputs = new HttpClientInputs();
        httpClientInputs.setUrl(Utilities.getDcaDeployUrl(protocol, host, port));
        httpClientInputs.setHeaders(Utilities.getAuthHeaders(authToken, refreshToken));
        Utilities.setProxy(httpClientInputs, proxyHost, proxyPort, proxyUsername, proxyPassword);
        Utilities.setSecurityInputs(httpClientInputs, trustAllRoots, x509HostnameVerifier, trustKeystore, trustPassword, keystore, keystorePassword);
        Utilities.setConnectionParameters(httpClientInputs, connectTimeout, socketTimeout, useCookies, keepAlive, connectionsMaxPerRoot, connectionsMaxTotal);
        httpClientInputs.setContentType("application/json");
        httpClientInputs.setFollowRedirects("true");
        httpClientInputs.setMethod("POST");
        try {
            ObjectMapper mapper = new ObjectMapper();
            List resources = (List)mapper.readValue(deploymentResources, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, DcaResourceModel.class));
            DcaDeploymentModel dcaDeploymentModel = new DcaDeploymentModel(deploymentName, deploymentDesc, deploymentTemplateId, resources);
            httpClientInputs.setBody(dcaDeploymentModel.toJson());
            Map httpClientResult = new CSHttpClient().execute(httpClientInputs);
            Map resultMap = (Map)mapper.readValue((String)httpClientResult.get("returnResult"), Map.class);
            if (Integer.parseInt((String)httpClientResult.get("statusCode")) != 200) {
                return OutputUtilities.getFailureResultsMap((String)resultMap.get("message").toString());
            }
            boolean async = BooleanUtilities.toBoolean((String)asyncStr);
            int timeout = Integer.parseInt(timeoutStr);
            int pollingInterval = Integer.parseInt(pollingIntervalStr);
            if (async) {
                return OutputUtilities.getSuccessResultsMap((String)((String)httpClientResult.get("returnResult")));
            }
            long finishTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeout);
            String deploymentUuid = resultMap.get("uuid").toString();
            do {
                Thread.sleep(TimeUnit.SECONDS.toMillis(pollingInterval));
                Map<String, String> getDeploymentMap = new GetDeployment().execute(host, port, protocolInp, authToken, refreshToken, deploymentUuid, proxyHost, proxyPort, proxyUsername, proxyPassword, trustAllRoots, x509HostnameVerifier, trustKeystoreInp, trustPasswordInp, keystoreInp, keystorePasswordInp, connectTimeout, socketTimeout, useCookies, keepAlive, connectionsMaxPerRoot, connectionsMaxTotal);
                String getDeploymentResult = getDeploymentMap.get("returnResult");
                String status = getDeploymentMap.get("status");
                if (status.equalsIgnoreCase("SUCCESS")) {
                    Map successResultsMap = OutputUtilities.getSuccessResultsMap((String)getDeploymentResult);
                    successResultsMap.put("status", status);
                    return successResultsMap;
                }
                if (!status.equalsIgnoreCase("FAILED")) continue;
                Map failureResultsMap = OutputUtilities.getFailureResultsMap((String)getDeploymentResult, (Throwable)new Exception("Failed to deploy template!"));
                failureResultsMap.put("status", status);
                return failureResultsMap;
            } while (System.currentTimeMillis() <= finishTime);
            throw new TimeoutException("Deploy Template timeout.");
        }
        catch (Exception e) {
            return OutputUtilities.getFailureResultsMap((Throwable)e);
        }
    }
}

