/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.dca.actions.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.oo.sdk.content.annotations.Action;
import com.hp.oo.sdk.content.annotations.Output;
import com.hp.oo.sdk.content.annotations.Param;
import com.hp.oo.sdk.content.annotations.Response;
import com.hp.oo.sdk.content.plugin.ActionMetadata.MatchType;
import com.hp.oo.sdk.content.plugin.ActionMetadata.ResponseType;
import io.cloudslang.content.dca.utils.Constants;
import io.cloudslang.content.dca.utils.DefaultValues;
import io.cloudslang.content.dca.utils.Utilities;
import io.cloudslang.content.dca.utils.Validator;
import io.cloudslang.content.httpclient.CSHttpClient;
import io.cloudslang.content.httpclient.HttpClientInputs;
import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import io.cloudslang.content.utils.OutputUtilities;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GetAuthenticationToken {
    @Action(name="Get Authentication Token", description="This operation is used to retrieve an authentication token from an IdM instance, in order to be used with the DCA operations and flows.", outputs={@Output(value="returnResult", description="The authentication token in case of success, or an error message in case of failure."), @Output(value="returnCode", description="The return code of the operation, 0 in case of success, -1 in case of failure"), @Output(value="exception", description="In case of failure, the error message, otherwise empty."), @Output(value="authToken", description="The authentication token returned by the IdM service."), @Output(value="refreshToken", description="The refresh token returned by the IdM service.")}, responses={@Response(text="success", field="returnCode", value="0", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.RESOLVED, description="Operation succeeded, returnCode is '0'."), @Response(text="failure", field="returnCode", value="-1", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.ERROR, description="Operation failed, returnCode is '-1'.")})
    public Map<String, String> execute(@Param(value="idmHost", required=true, description="The hostname or IP of the IdM with which to authenticate.") String idmHostInp, @Param(value="idmPort", description="The port on which IdM is listening on the host.") String idmPortInp, @Param(value="protocol", description="The protocol to use when connecting to IdM.") String protocolInp, @Param(value="idmUsername", required=true, description="The IdM username to use when authenticating.") String idmUsername, @Param(value="idmPassword", required=true, encrypted=true, description="The password of the IdM user.") String idmPassword, @Param(value="dcaUsername", required=true, description="The DCA user to authenticate.") String dcaUsername, @Param(value="dcaPassword", required=true, encrypted=true, description="The password of the DCA user.") String dcaPassword, @Param(value="dcaTenantName", description="The tenant of the DCA user to authenticate.") String dcaTenantInp, @Param(value="preemptiveAuth", description="If this field is 'true' authentication info will be sent in the first request. If this is 'false' a request with no authentication info will be made and if server responds with 401 and a header like WWW-Authenticate: Basic realm=\"myRealm\" only then the authentication info will be sent.") String preemptiveAuth, @Param(value="proxyHost", description="The proxy server used to access the web site.") String proxyHost, @Param(value="proxyPort", description="The proxy server port. Default value: 8080. Valid values: -1 and integer values greater than 0. The value '-1' indicates that the proxy port is not set and the protocol default port will be used. If the protocol is 'http' and the 'proxyPort' is set to '-1' then port '80' will be used.") String proxyPort, @Param(value="proxyUsername", description="The user name used when connecting to the proxy.") String proxyUsername, @Param(value="proxyPassword", encrypted=true, description="The proxy server password associated with the proxyUsername input value.") String proxyPassword, @Param(value="trustAllRoots", description="Specifies whether to enable weak security over SSL/TSL. A certificate is trusted even if no trusted certification authority issued it.") String trustAllRoots, @Param(value="x509HostnameVerifier", description="Specifies the way the server hostname must match a domain name in the subject's Common Name (CN) or subjectAltName field of the X.509 certificate. Set this to \"allow_all\" to skip any checking. For the value \"browser_compatible\" the hostname verifier works the same way as Curl and Firefox. The hostname must match either the first CN, or any of the subject-alts. A wildcard can occur in the CN, and in any of the subject-alts. The only difference between \"browser_compatible\" and \"strict\" is that a wildcard (such as \"*.foo.com\") with \"browser_compatible\" matches all subdomains, including \"a.b.foo.com\".") String x509HostnameVerifier, @Param(value="trustKeystore", description="The pathname of the Java TrustStore file. This contains certificates from other parties that you expect to communicate with, or from Certificate Authorities that you trust to identify other parties.  If the protocol (specified by the 'url') is not 'https' or if trustAllRoots is 'true' this input is ignored. Format: Java KeyStore (JKS)") String trustKeystoreInp, @Param(value="trustPassword", encrypted=true, description="The password associated with the TrustStore file. If trustAllRoots is false and trustKeystore is empty, trustPassword default will be supplied.") String trustPasswordInp, @Param(value="keystore", description="The pathname of the Java KeyStore file. You only need this if the server requires client authentication. If the protocol (specified by the 'url') is not 'https' or if trustAllRoots is 'true' this input is ignored. Format: Java KeyStore (JKS)") String keystoreInp, @Param(value="keystorePassword", encrypted=true, description="The password associated with the KeyStore file. If trustAllRoots is false and keystore is empty, keystorePassword default will be supplied.") String keystorePasswordInp, @Param(value="connectTimeout", description="The time to wait for a connection to be established, in seconds. A timeout value of '0' represents an infinite timeout.") String connectTimeout, @Param(value="socketTimeout", description="The timeout for waiting for data (a maximum period inactivity between two consecutive data packets), in seconds. A socketTimeout value of '0' represents an infinite timeout.") String socketTimeout, @Param(value="useCookies", description="Specifies whether to enable cookie tracking or not. Cookies are stored between consecutive calls in a serializable session object therefore they will be available on a branch level. If you specify a non-boolean value, the default value is used.") String useCookies, @Param(value="keepAlive", description="Specifies whether to create a shared connection that will be used in subsequent calls. If keepAlive is false, the already open connection will be used and after execution it will close it.") String keepAlive, @Param(value="connectionsMaxPerRoute", description="The maximum limit of connections on a per route basis.") String connectionsMaxPerRoot, @Param(value="connectionsMaxTotal", description="The maximum limit of connections in total.") String connectionsMaxTotal) {
        String idmPortStr = (String)StringUtils.defaultIfEmpty((CharSequence)idmPortInp, (CharSequence)"5443");
        String protocolStr = (String)StringUtils.defaultIfEmpty((CharSequence)protocolInp, (CharSequence)"https");
        String dcaTenant = (String)StringUtils.defaultIfEmpty((CharSequence)dcaTenantInp, (CharSequence)"PROVIDER");
        String trustKeystore = (String)StringUtils.defaultIfEmpty((CharSequence)trustKeystoreInp, (CharSequence)DefaultValues.DEFAULT_JAVA_KEYSTORE);
        String trustPassword = (String)StringUtils.defaultIfEmpty((CharSequence)trustPasswordInp, (CharSequence)"changeit");
        String keystore = (String)StringUtils.defaultIfEmpty((CharSequence)keystoreInp, (CharSequence)DefaultValues.DEFAULT_JAVA_KEYSTORE);
        String keystorePassword = (String)StringUtils.defaultIfEmpty((CharSequence)keystorePasswordInp, (CharSequence)"changeit");
        Validator validator = new Validator();
        validator.validatePort(idmPortStr);
        validator.validateProtocol(protocolStr);
        if (!validator.getValidationErrorList().isEmpty()) {
            return OutputUtilities.getFailureResultsMap((String)StringUtils.join(validator.getValidationErrorList(), (String)System.lineSeparator()));
        }
        HttpClientInputs httpClientInputs = new HttpClientInputs();
        httpClientInputs.setUrl(Utilities.getIdmUrl(protocolInp, idmHostInp, idmPortStr));
        Utilities.setIdmAuthentication(httpClientInputs, AuthTypes.BASIC, idmUsername, idmPassword, preemptiveAuth);
        Utilities.setProxy(httpClientInputs, proxyHost, proxyPort, proxyUsername, proxyPassword);
        Utilities.setSecurityInputs(httpClientInputs, trustAllRoots, x509HostnameVerifier, trustKeystore, trustPassword, keystore, keystorePassword);
        Utilities.setDcaCredentials(httpClientInputs, dcaUsername, dcaPassword, dcaTenant);
        Utilities.setConnectionParameters(httpClientInputs, connectTimeout, socketTimeout, useCookies, keepAlive, connectionsMaxPerRoot, connectionsMaxTotal);
        httpClientInputs.setContentType("application/json");
        httpClientInputs.setResponseCharacterSet(StandardCharsets.UTF_8.toString());
        httpClientInputs.setRequestCharacterSet(StandardCharsets.UTF_8.toString());
        httpClientInputs.setFollowRedirects("true");
        httpClientInputs.setMethod("POST");
        try {
            Map httpClientResultMap = new CSHttpClient().execute(httpClientInputs);
            ObjectMapper mapper = new ObjectMapper();
            Map responseMap = (Map)mapper.readValue((String)httpClientResultMap.get("returnResult"), Map.class);
            if (Integer.parseInt((String)httpClientResultMap.get("statusCode")) == 200) {
                String authToken = ((LinkedHashMap)responseMap.get("token")).get("id").toString();
                String refreshToken = responseMap.get("refreshToken").toString();
                Map resultMap = OutputUtilities.getSuccessResultsMap((String)authToken);
                resultMap.put("authToken", authToken);
                resultMap.put("refreshToken", refreshToken);
                return resultMap;
            }
            return OutputUtilities.getFailureResultsMap((String)StringUtils.join((Object[])new Object[]{responseMap.get("errors"), Constants.NEW_LINE}));
        }
        catch (Exception e) {
            return OutputUtilities.getFailureResultsMap((String)"Failed to get authentication token.", (Throwable)e);
        }
    }
}

