/*
 * Decompiled with CFR 0.152.
 */
package io.cequence.openaiscala.gemini.service.impl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.cequence.openaiscala.OpenAIScalaClientException;
import io.cequence.openaiscala.domain.AssistantMessage;
import io.cequence.openaiscala.domain.AssistantMessage$;
import io.cequence.openaiscala.domain.BaseMessage;
import io.cequence.openaiscala.domain.BaseMessage$;
import io.cequence.openaiscala.domain.ChatRole;
import io.cequence.openaiscala.domain.DeveloperMessage;
import io.cequence.openaiscala.domain.DeveloperMessage$;
import io.cequence.openaiscala.domain.ImageURLContent;
import io.cequence.openaiscala.domain.ImageURLContent$;
import io.cequence.openaiscala.domain.JsonSchema;
import io.cequence.openaiscala.domain.SystemMessage;
import io.cequence.openaiscala.domain.SystemMessage$;
import io.cequence.openaiscala.domain.TextContent;
import io.cequence.openaiscala.domain.TextContent$;
import io.cequence.openaiscala.domain.UserMessage;
import io.cequence.openaiscala.domain.UserMessage$;
import io.cequence.openaiscala.domain.UserSeqMessage;
import io.cequence.openaiscala.domain.UserSeqMessage$;
import io.cequence.openaiscala.domain.response.ChatCompletionChoiceChunkInfo$;
import io.cequence.openaiscala.domain.response.ChatCompletionChoiceInfo$;
import io.cequence.openaiscala.domain.response.ChatCompletionChunkResponse;
import io.cequence.openaiscala.domain.response.ChatCompletionChunkResponse$;
import io.cequence.openaiscala.domain.response.ChatCompletionResponse;
import io.cequence.openaiscala.domain.response.ChatCompletionResponse$;
import io.cequence.openaiscala.domain.response.ChunkMessageSpec;
import io.cequence.openaiscala.domain.response.ChunkMessageSpec$;
import io.cequence.openaiscala.domain.response.PromptTokensDetails$;
import io.cequence.openaiscala.domain.response.UsageInfo;
import io.cequence.openaiscala.domain.response.UsageInfo$;
import io.cequence.openaiscala.domain.settings.ChatCompletionResponseFormatType;
import io.cequence.openaiscala.domain.settings.CreateChatCompletionSettings;
import io.cequence.openaiscala.domain.settings.JsonSchemaDef;
import io.cequence.openaiscala.gemini.domain.CachedContent$;
import io.cequence.openaiscala.gemini.domain.ChatRole;
import io.cequence.openaiscala.gemini.domain.ChatRole$Model$;
import io.cequence.openaiscala.gemini.domain.ChatRole$User$;
import io.cequence.openaiscala.gemini.domain.Content;
import io.cequence.openaiscala.gemini.domain.Content$;
import io.cequence.openaiscala.gemini.domain.Expiration;
import io.cequence.openaiscala.gemini.domain.Modality;
import io.cequence.openaiscala.gemini.domain.Part;
import io.cequence.openaiscala.gemini.domain.Part$FileData$;
import io.cequence.openaiscala.gemini.domain.Part$InlineData$;
import io.cequence.openaiscala.gemini.domain.Part$Text$;
import io.cequence.openaiscala.gemini.domain.Schema;
import io.cequence.openaiscala.gemini.domain.Schema$;
import io.cequence.openaiscala.gemini.domain.SchemaType$ARRAY$;
import io.cequence.openaiscala.gemini.domain.SchemaType$BOOLEAN$;
import io.cequence.openaiscala.gemini.domain.SchemaType$INTEGER$;
import io.cequence.openaiscala.gemini.domain.SchemaType$NUMBER$;
import io.cequence.openaiscala.gemini.domain.SchemaType$OBJECT$;
import io.cequence.openaiscala.gemini.domain.SchemaType$STRING$;
import io.cequence.openaiscala.gemini.domain.SchemaType$TYPE_UNSPECIFIED$;
import io.cequence.openaiscala.gemini.domain.Tool;
import io.cequence.openaiscala.gemini.domain.response.GenerateContentResponse;
import io.cequence.openaiscala.gemini.domain.response.UsageMetadata;
import io.cequence.openaiscala.gemini.domain.settings.CreateChatCompletionSettingsOps$;
import io.cequence.openaiscala.gemini.domain.settings.GenerateContentSettings;
import io.cequence.openaiscala.gemini.domain.settings.GenerateContentSettings$;
import io.cequence.openaiscala.gemini.domain.settings.GenerationConfig;
import io.cequence.openaiscala.gemini.domain.settings.GenerationConfig$;
import io.cequence.openaiscala.gemini.domain.settings.SafetySetting;
import io.cequence.openaiscala.gemini.domain.settings.SpeechConfig;
import io.cequence.openaiscala.gemini.domain.settings.ToolConfig;
import io.cequence.openaiscala.gemini.service.GeminiService;
import io.cequence.openaiscala.service.OpenAIChatCompletionService;
import io.cequence.openaiscala.service.OpenAIChatCompletionStreamedServiceExtra;
import io.cequence.openaiscala.service.OpenAIServiceConsts;
import io.cequence.openaiscala.service.OpenAIServiceConsts$DefaultSettings$;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OpenAIGeminiChatCompletionService
implements OpenAIServiceConsts,
OpenAIChatCompletionService,
OpenAIChatCompletionStreamedServiceExtra {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(OpenAIGeminiChatCompletionService.class.getDeclaredField("0bitmap$1"));
    private String defaultCoreUrl;
    private String configPrefix;
    private String configFileName;
    public OpenAIServiceConsts$DefaultSettings$ DefaultSettings$lzy1;
    public long 0bitmap$1;
    private final GeminiService underlying;
    private final ExecutionContext executionContext;
    private final Logger logger;

    public OpenAIGeminiChatCompletionService(GeminiService underlying, ExecutionContext executionContext) {
        this.underlying = underlying;
        this.executionContext = executionContext;
        OpenAIServiceConsts.$init$((OpenAIServiceConsts)this);
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        Statics.releaseFence();
    }

    public String defaultCoreUrl() {
        return this.defaultCoreUrl;
    }

    public String configPrefix() {
        return this.configPrefix;
    }

    public String configFileName() {
        return this.configFileName;
    }

    public final OpenAIServiceConsts$DefaultSettings$ DefaultSettings() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    OpenAIServiceConsts$DefaultSettings$ openAIServiceConsts$DefaultSettings$;
                    this.DefaultSettings$lzy1 = openAIServiceConsts$DefaultSettings$ = new OpenAIServiceConsts$DefaultSettings$((OpenAIServiceConsts)this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return openAIServiceConsts$DefaultSettings$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.DefaultSettings$lzy1;
    }

    public void io$cequence$openaiscala$service$OpenAIServiceConsts$_setter_$defaultCoreUrl_$eq(String x$0) {
        this.defaultCoreUrl = x$0;
    }

    public void io$cequence$openaiscala$service$OpenAIServiceConsts$_setter_$configPrefix_$eq(String x$0) {
        this.configPrefix = x$0;
    }

    public void io$cequence$openaiscala$service$OpenAIServiceConsts$_setter_$configFileName_$eq(String x$0) {
        this.configFileName = x$0;
    }

    public Logger logger() {
        return this.logger;
    }

    public Future<ChatCompletionResponse> createChatCompletion(Seq<BaseMessage> messages, CreateChatCompletionSettings settings2) {
        Tuple2<Seq<BaseMessage>, Option<BaseMessage>> tuple2 = this.splitMessage(messages);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq userMessages = (Seq)tuple2._1();
        Option systemMessage = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)userMessages, (Object)systemMessage);
        Seq userMessages2 = (Seq)tuple22._1();
        Option systemMessage2 = (Option)tuple22._2();
        return this.handleCaching((Option<BaseMessage>)systemMessage2, (Seq<BaseMessage>)userMessages2, settings2).flatMap((Function1 & Serializable)settings -> this.underlying.generateContent((Seq<Content>)((Seq)userMessages2.map((Function1 & Serializable)message -> this.toGeminiContent((BaseMessage)message))), (GenerateContentSettings)settings).map((Function1 & Serializable)response -> this.toOpenAIResponse((GenerateContentResponse)response), this.executionContext), this.executionContext);
    }

    public Source<ChatCompletionChunkResponse, NotUsed> createChatCompletionStreamed(Seq<BaseMessage> messages, CreateChatCompletionSettings settings2) {
        Tuple2<Seq<BaseMessage>, Option<BaseMessage>> tuple2 = this.splitMessage(messages);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq userMessages = (Seq)tuple2._1();
        Option systemMessage = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)userMessages, (Object)systemMessage);
        Seq userMessages2 = (Seq)tuple22._1();
        Option systemMessage2 = (Option)tuple22._2();
        Future futureSource = this.handleCaching((Option<BaseMessage>)systemMessage2, (Seq<BaseMessage>)userMessages2, settings2).map((Function1 & Serializable)settings -> (Source)this.underlying.generateContentStreamed((Seq<Content>)((Seq)userMessages2.map((Function1 & Serializable)message -> this.toGeminiContent((BaseMessage)message))), (GenerateContentSettings)settings).map((Function1 & Serializable)response -> this.toOpenAIChunkResponse((GenerateContentResponse)response)), this.executionContext);
        return Source$.MODULE$.fromFutureSource(futureSource).mapMaterializedValue((Function1 & Serializable)_$1 -> NotUsed$.MODULE$);
    }

    private Future<GenerateContentSettings> handleCaching(Option<BaseMessage> systemMessage, Seq<BaseMessage> userMessages, CreateChatCompletionSettings settings) {
        return (Future)CreateChatCompletionSettingsOps$.MODULE$.RichGeminiCreateChatCompletionSettings(settings).getSystemCacheName().map((Function1 & Serializable)cacheName -> {
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Using a system message for Gemini from cache: {}", cacheName);
            }
            GenerateContentSettings generateContentSettings = this.toGeminiSettings(settings, (Option<BaseMessage>)None$.MODULE$);
            Some some = Some$.MODULE$.apply(cacheName);
            String string = generateContentSettings.copy$default$1();
            Option<Seq<Tool>> option = generateContentSettings.copy$default$2();
            Option<ToolConfig> option2 = generateContentSettings.copy$default$3();
            Option<Seq<SafetySetting>> option3 = generateContentSettings.copy$default$4();
            Option<Content> option4 = generateContentSettings.copy$default$5();
            Option<GenerationConfig> option5 = generateContentSettings.copy$default$6();
            return Future$.MODULE$.successful((Object)generateContentSettings.copy(string, option, option2, option3, option4, option5, (Option<String>)some));
        }).getOrElse(() -> this.handleCaching$$anonfun$2(systemMessage, settings));
    }

    private Future<String> cacheMessages(BaseMessage systemMessage, Option<BaseMessage> userMessage, CreateChatCompletionSettings settings) {
        String systemMessageContent = (String)BaseMessage$.MODULE$.getTextContent(systemMessage).getOrElse(OpenAIGeminiChatCompletionService::$anonfun$2);
        Option userMessageContent = userMessage.flatMap((Function1 & Serializable)message -> BaseMessage$.MODULE$.getTextContent(message));
        Some some = Some$.MODULE$.apply((Object)Content$.MODULE$.textPart(systemMessageContent, ChatRole$User$.MODULE$));
        Seq seq = (Seq)userMessageContent.map((Function1 & Serializable)content -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Content[]{Content$.MODULE$.textPart((String)content, ChatRole$User$.MODULE$)}))).getOrElse(OpenAIGeminiChatCompletionService::$anonfun$5);
        Seq<Tool> seq2 = CachedContent$.MODULE$.$lessinit$greater$default$2();
        Expiration expiration = CachedContent$.MODULE$.$lessinit$greater$default$3();
        Option<String> option = CachedContent$.MODULE$.$lessinit$greater$default$4();
        Option<String> option2 = CachedContent$.MODULE$.$lessinit$greater$default$5();
        Option<ToolConfig> option3 = CachedContent$.MODULE$.$lessinit$greater$default$8();
        return this.underlying.createCachedContent(CachedContent$.MODULE$.apply((Seq<Content>)seq, seq2, expiration, option, option2, settings.model(), (Option<Content>)some, option3)).map((Function1 & Serializable)_$2 -> (String)_$2.name().get(), this.executionContext);
    }

    private Tuple2<Seq<BaseMessage>, Option<BaseMessage>> splitMessage(Seq<BaseMessage> messages) {
        Tuple2 tuple2 = messages.partition((Function1 & Serializable)x$1 -> {
            BaseMessage baseMessage = x$1;
            if (baseMessage instanceof SystemMessage) {
                return true;
            }
            return baseMessage instanceof DeveloperMessage;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq systemMessages = (Seq)tuple2._1();
        Seq userMessages = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)systemMessages, (Object)userMessages);
        Seq systemMessages2 = (Seq)tuple22._1();
        Seq userMessages2 = (Seq)tuple22._2();
        if (systemMessages2.size() > 1) {
            throw new OpenAIScalaClientException("Only one system message is supported.");
        }
        return Tuple2$.MODULE$.apply((Object)userMessages2, (Object)systemMessages2.headOption());
    }

    private Content toGeminiContent(BaseMessage message) {
        BaseMessage baseMessage = message;
        if (baseMessage instanceof SystemMessage) {
            SystemMessage systemMessage = SystemMessage$.MODULE$.unapply((SystemMessage)baseMessage);
            String string = systemMessage._1();
            Option option = systemMessage._2();
            String content = string;
            return Content$.MODULE$.apply((Seq<Part>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part.Text[]{Part$Text$.MODULE$.apply(content)}))), (Option<ChatRole>)Some$.MODULE$.apply((Object)ChatRole$User$.MODULE$));
        }
        if (baseMessage instanceof DeveloperMessage) {
            DeveloperMessage developerMessage = DeveloperMessage$.MODULE$.unapply((DeveloperMessage)baseMessage);
            String string = developerMessage._1();
            Option option = developerMessage._2();
            String content = string;
            return Content$.MODULE$.apply((Seq<Part>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part.Text[]{Part$Text$.MODULE$.apply(content)}))), (Option<ChatRole>)Some$.MODULE$.apply((Object)ChatRole$User$.MODULE$));
        }
        if (baseMessage instanceof UserMessage) {
            UserMessage userMessage = UserMessage$.MODULE$.unapply((UserMessage)baseMessage);
            String string = userMessage._1();
            Option option = userMessage._2();
            String content = string;
            return Content$.MODULE$.apply((Seq<Part>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part.Text[]{Part$Text$.MODULE$.apply(content)}))), (Option<ChatRole>)Some$.MODULE$.apply((Object)ChatRole$User$.MODULE$));
        }
        if (baseMessage instanceof UserSeqMessage) {
            UserSeqMessage userSeqMessage = UserSeqMessage$.MODULE$.unapply((UserSeqMessage)baseMessage);
            Seq seq = userSeqMessage._1();
            Option option = userSeqMessage._2();
            Seq content = seq;
            Seq parts = (Seq)content.map((Function1 & Serializable)x$1 -> {
                Part part;
                io.cequence.openaiscala.domain.Content content = x$1;
                if (content instanceof TextContent) {
                    String string;
                    TextContent textContent = TextContent$.MODULE$.unapply((TextContent)content);
                    String content2 = string = textContent._1();
                    part = Part$Text$.MODULE$.apply(content2);
                } else if (content instanceof ImageURLContent) {
                    ImageURLContent imageURLContent = ImageURLContent$.MODULE$.unapply((ImageURLContent)content);
                    String string = imageURLContent._1();
                    String url = string;
                    if (url.startsWith("data:")) {
                        String mediaTypeEncodingAndData = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(url), 5);
                        String mediaType = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(mediaTypeEncodingAndData), (Function1 & Serializable)_$3 -> OpenAIGeminiChatCompletionService.$anonfun$8(BoxesRunTime.unboxToChar((Object)_$3)));
                        String encodingAndData = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(mediaTypeEncodingAndData), mediaType.length() + 1);
                        String encoding = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(encodingAndData), (Function1 & Serializable)_$4 -> OpenAIGeminiChatCompletionService.$anonfun$9(BoxesRunTime.unboxToChar((Object)_$4)));
                        String data = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(encodingAndData), encoding.length() + 1);
                        part = Part$InlineData$.MODULE$.apply(mediaType, data);
                    } else {
                        part = Part$FileData$.MODULE$.apply((Option<String>)None$.MODULE$, url);
                    }
                } else {
                    throw new MatchError((Object)content);
                }
                return part;
            });
            return Content$.MODULE$.apply((Seq<Part>)parts, (Option<ChatRole>)Some$.MODULE$.apply((Object)ChatRole$User$.MODULE$));
        }
        if (baseMessage instanceof AssistantMessage) {
            AssistantMessage assistantMessage = AssistantMessage$.MODULE$.unapply((AssistantMessage)baseMessage);
            String string = assistantMessage._1();
            Option option = assistantMessage._2();
            Option option2 = assistantMessage._3();
            String content = string;
            return Content$.MODULE$.apply((Seq<Part>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part.Text[]{Part$Text$.MODULE$.apply(content)}))), (Option<ChatRole>)Some$.MODULE$.apply((Object)ChatRole$Model$.MODULE$));
        }
        throw new OpenAIScalaClientException("Unsupported message type for Gemini.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GenerateContentSettings toGeminiSettings(CreateChatCompletionSettings settings, Option<BaseMessage> systemMessage) {
        None$ none$;
        ChatCompletionResponseFormatType responseFormat;
        ChatCompletionResponseFormatType chatCompletionResponseFormatType = responseFormat = (ChatCompletionResponseFormatType)settings.response_format_type().getOrElse(OpenAIGeminiChatCompletionService::$anonfun$10);
        ChatCompletionResponseFormatType.json_schema$ json_schema$2 = ChatCompletionResponseFormatType.json_schema$.MODULE$;
        if (!(chatCompletionResponseFormatType != null ? !chatCompletionResponseFormatType.equals(json_schema$2) : json_schema$2 != null) && settings.jsonSchema().isDefined()) {
            Either either = ((JsonSchemaDef)settings.jsonSchema().get()).structure();
            if (either instanceof Left) {
                JsonSchema schema = (JsonSchema)((Left)either).value();
                none$ = Some$.MODULE$.apply((Object)this.toGeminiJSONSchema(schema));
            } else {
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Logger LoggerImpl_this = this.logger();
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("Map-like legacy JSON schema is not supported for conversion to Gemini schema.");
                }
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ jsonSchema = none$;
        this.checkNotSupported(settings);
        return GenerateContentSettings$.MODULE$.apply(settings.model(), (Option<Seq<Tool>>)None$.MODULE$, (Option<ToolConfig>)None$.MODULE$, (Option<Seq<SafetySetting>>)None$.MODULE$, (Option<Content>)systemMessage.map((Function1 & Serializable)message -> this.toGeminiContent((BaseMessage)message)), (Option<GenerationConfig>)Some$.MODULE$.apply((Object)GenerationConfig$.MODULE$.apply((Option<Seq<String>>)(settings.stop().nonEmpty() ? Some$.MODULE$.apply((Object)settings.stop()) : None$.MODULE$), (Option<String>)(jsonSchema.isDefined() ? Some$.MODULE$.apply((Object)"application/json") : None$.MODULE$), (Option<Schema>)jsonSchema, (Option<Seq<Modality>>)None$.MODULE$, (Option<Object>)settings.n(), (Option<Object>)settings.max_tokens(), (Option<Object>)settings.temperature(), (Option<Object>)settings.top_p(), (Option<Object>)None$.MODULE$, (Option<Object>)settings.seed(), (Option<Object>)settings.presence_penalty(), (Option<Object>)settings.frequency_penalty(), (Option<Object>)settings.logprobs(), (Option<Object>)settings.top_logprobs(), (Option<Object>)None$.MODULE$, (Option<SpeechConfig>)None$.MODULE$)), (Option<String>)None$.MODULE$);
    }

    private void checkNotSupported(CreateChatCompletionSettings settings) {
        this.notSupported$1(settings, (Function1 & Serializable)_$6 -> _$6.reasoning_effort(), "reasoning_effort");
        this.notSupported$1(settings, (Function1 & Serializable)_$7 -> _$7.service_tier(), "service_tier");
        this.notSupported$1(settings, (Function1 & Serializable)_$8 -> _$8.parallel_tool_calls(), "parallel_tool_calls");
        this.notSupportedCollection$1(settings, (Function1 & Serializable)_$9 -> _$9.metadata(), "metadata");
        this.notSupportedCollection$1(settings, (Function1 & Serializable)_$10 -> _$10.logit_bias(), "logit_bias");
        this.notSupported$1(settings, (Function1 & Serializable)_$11 -> _$11.user(), "user");
        this.notSupported$1(settings, (Function1 & Serializable)_$12 -> _$12.store(), "store");
    }

    private Schema toGeminiJSONSchema(JsonSchema jsonSchema) {
        JsonSchema jsonSchema2 = jsonSchema;
        if (jsonSchema2 instanceof JsonSchema.String) {
            JsonSchema.String string = JsonSchema.String$.MODULE$.unapply((JsonSchema.String)jsonSchema2);
            Option option = string._1();
            Seq seq = string._2();
            Option description = option;
            Seq enumVals = seq;
            SchemaType$STRING$ schemaType$STRING$ = SchemaType$STRING$.MODULE$;
            Some some = Some$.MODULE$.apply((Object)enumVals);
            Option<String> option2 = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<Object> option3 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<String> option4 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option5 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Map<String, Schema>> option6 = Schema$.MODULE$.$lessinit$greater$default$8();
            Option<Seq<String>> option7 = Schema$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<String>> option8 = Schema$.MODULE$.$lessinit$greater$default$10();
            Option<Schema> option9 = Schema$.MODULE$.$lessinit$greater$default$11();
            return Schema$.MODULE$.apply(schemaType$STRING$, option2, (Option<String>)description, option3, (Option<Seq<String>>)some, option4, option5, option6, option7, option8, option9);
        }
        if (jsonSchema2 instanceof JsonSchema.Number) {
            Option option;
            JsonSchema.Number number = JsonSchema.Number$.MODULE$.unapply((JsonSchema.Number)jsonSchema2);
            Option description = option = number._1();
            SchemaType$NUMBER$ schemaType$NUMBER$ = SchemaType$NUMBER$.MODULE$;
            Option<String> option10 = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<Object> option11 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<String>> option12 = Schema$.MODULE$.$lessinit$greater$default$5();
            Option<String> option13 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option14 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Map<String, Schema>> option15 = Schema$.MODULE$.$lessinit$greater$default$8();
            Option<Seq<String>> option16 = Schema$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<String>> option17 = Schema$.MODULE$.$lessinit$greater$default$10();
            Option<Schema> option18 = Schema$.MODULE$.$lessinit$greater$default$11();
            return Schema$.MODULE$.apply(schemaType$NUMBER$, option10, (Option<String>)description, option11, option12, option13, option14, option15, option16, option17, option18);
        }
        if (jsonSchema2 instanceof JsonSchema.Integer) {
            Option option;
            JsonSchema.Integer integer = JsonSchema.Integer$.MODULE$.unapply((JsonSchema.Integer)jsonSchema2);
            Option description = option = integer._1();
            SchemaType$INTEGER$ schemaType$INTEGER$ = SchemaType$INTEGER$.MODULE$;
            Option<String> option19 = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<Object> option20 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<String>> option21 = Schema$.MODULE$.$lessinit$greater$default$5();
            Option<String> option22 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option23 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Map<String, Schema>> option24 = Schema$.MODULE$.$lessinit$greater$default$8();
            Option<Seq<String>> option25 = Schema$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<String>> option26 = Schema$.MODULE$.$lessinit$greater$default$10();
            Option<Schema> option27 = Schema$.MODULE$.$lessinit$greater$default$11();
            return Schema$.MODULE$.apply(schemaType$INTEGER$, option19, (Option<String>)description, option20, option21, option22, option23, option24, option25, option26, option27);
        }
        if (jsonSchema2 instanceof JsonSchema.Boolean) {
            Option option;
            JsonSchema.Boolean boolean_ = JsonSchema.Boolean$.MODULE$.unapply((JsonSchema.Boolean)jsonSchema2);
            Option description = option = boolean_._1();
            SchemaType$BOOLEAN$ schemaType$BOOLEAN$ = SchemaType$BOOLEAN$.MODULE$;
            Option<String> option28 = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<Object> option29 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<String>> option30 = Schema$.MODULE$.$lessinit$greater$default$5();
            Option<String> option31 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option32 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Map<String, Schema>> option33 = Schema$.MODULE$.$lessinit$greater$default$8();
            Option<Seq<String>> option34 = Schema$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<String>> option35 = Schema$.MODULE$.$lessinit$greater$default$10();
            Option<Schema> option36 = Schema$.MODULE$.$lessinit$greater$default$11();
            return Schema$.MODULE$.apply(schemaType$BOOLEAN$, option28, (Option<String>)description, option29, option30, option31, option32, option33, option34, option35, option36);
        }
        if (jsonSchema2 instanceof JsonSchema.Null && JsonSchema.Null$.MODULE$.unapply((JsonSchema.Null)jsonSchema2)) {
            return Schema$.MODULE$.apply(SchemaType$TYPE_UNSPECIFIED$.MODULE$, Schema$.MODULE$.$lessinit$greater$default$2(), Schema$.MODULE$.$lessinit$greater$default$3(), Schema$.MODULE$.$lessinit$greater$default$4(), Schema$.MODULE$.$lessinit$greater$default$5(), Schema$.MODULE$.$lessinit$greater$default$6(), Schema$.MODULE$.$lessinit$greater$default$7(), Schema$.MODULE$.$lessinit$greater$default$8(), Schema$.MODULE$.$lessinit$greater$default$9(), Schema$.MODULE$.$lessinit$greater$default$10(), Schema$.MODULE$.$lessinit$greater$default$11());
        }
        if (jsonSchema2 instanceof JsonSchema.Object) {
            Seq seq;
            JsonSchema.Object object = JsonSchema.Object$.MODULE$.unapply((JsonSchema.Object)jsonSchema2);
            Seq seq2 = object._1();
            Seq seq3 = object._2();
            Seq properties = seq2;
            Seq required = seq3;
            if (properties.nonEmpty()) {
                seq = properties;
            } else {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_filler_field");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JsonSchema.String$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)"Required field to satisfy Gemini's non-empty object schema requirement. Always output 'none'."), JsonSchema.String$.MODULE$.$lessinit$greater$default$2()));
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            Seq propertiesFinal = seq;
            SchemaType$OBJECT$ schemaType$OBJECT$ = SchemaType$OBJECT$.MODULE$;
            Some some = Some$.MODULE$.apply((Object)((IterableOnceOps)propertiesFinal.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    JsonSchema jsonSchema = (JsonSchema)tuple2._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.toGeminiJSONSchema(jsonSchema));
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Some some2 = Some$.MODULE$.apply((Object)required);
            Option<String> option = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<String> option37 = Schema$.MODULE$.$lessinit$greater$default$3();
            Option<Object> option38 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<String>> option39 = Schema$.MODULE$.$lessinit$greater$default$5();
            Option<String> option40 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option41 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Seq<String>> option42 = Schema$.MODULE$.$lessinit$greater$default$10();
            Option<Schema> option43 = Schema$.MODULE$.$lessinit$greater$default$11();
            return Schema$.MODULE$.apply(schemaType$OBJECT$, option, option37, option38, option39, option40, option41, (Option<Map<String, Schema>>)some, (Option<Seq<String>>)some2, option42, option43);
        }
        if (jsonSchema2 instanceof JsonSchema.Array) {
            JsonSchema jsonSchema3;
            JsonSchema.Array array = JsonSchema.Array$.MODULE$.unapply((JsonSchema.Array)jsonSchema2);
            JsonSchema items = jsonSchema3 = array._1();
            SchemaType$ARRAY$ schemaType$ARRAY$ = SchemaType$ARRAY$.MODULE$;
            Some some = Some$.MODULE$.apply((Object)this.toGeminiJSONSchema(items));
            Option<String> option = Schema$.MODULE$.$lessinit$greater$default$2();
            Option<String> option44 = Schema$.MODULE$.$lessinit$greater$default$3();
            Option<Object> option45 = Schema$.MODULE$.$lessinit$greater$default$4();
            Option<Seq<String>> option46 = Schema$.MODULE$.$lessinit$greater$default$5();
            Option<String> option47 = Schema$.MODULE$.$lessinit$greater$default$6();
            Option<String> option48 = Schema$.MODULE$.$lessinit$greater$default$7();
            Option<Map<String, Schema>> option49 = Schema$.MODULE$.$lessinit$greater$default$8();
            Option<Seq<String>> option50 = Schema$.MODULE$.$lessinit$greater$default$9();
            Option<Seq<String>> option51 = Schema$.MODULE$.$lessinit$greater$default$10();
            return Schema$.MODULE$.apply(schemaType$ARRAY$, option, option44, option45, option46, option47, option48, option49, option50, option51, (Option<Schema>)some);
        }
        throw new OpenAIScalaClientException("Unsupported JSON schema type for Gemini.");
    }

    private ChatCompletionResponse toOpenAIResponse(GenerateContentResponse response) {
        return ChatCompletionResponse$.MODULE$.apply("gemini", new Date(), response.modelVersion(), (Option)None$.MODULE$, (Seq)response.candidates().map((Function1 & Serializable)candidate -> {
            int n = BoxesRunTime.unboxToInt((Object)candidate.index().getOrElse(OpenAIGeminiChatCompletionService::$anonfun$12));
            AssistantMessage assistantMessage = this.toOpenAIAssistantMessage(candidate.content());
            Option option = candidate.finishReason().map((Function1 & Serializable)_$13 -> _$13.toString());
            None$ none$ = None$.MODULE$;
            return ChatCompletionChoiceInfo$.MODULE$.apply(assistantMessage, n, option, (Option)none$);
        }), (Option)Some$.MODULE$.apply((Object)this.toOpenAIUsage(response.usageMetadata())), (Option)Some$.MODULE$.apply((Object)response));
    }

    private ChatCompletionChunkResponse toOpenAIChunkResponse(GenerateContentResponse response) {
        return ChatCompletionChunkResponse$.MODULE$.apply("gemini", new Date(), response.modelVersion(), (Option)None$.MODULE$, (Seq)response.candidates().map((Function1 & Serializable)candidate -> {
            int n = BoxesRunTime.unboxToInt((Object)candidate.index().getOrElse(OpenAIGeminiChatCompletionService::$anonfun$14));
            ChunkMessageSpec chunkMessageSpec = this.toOpenAIAssistantChunkMessage(candidate.content());
            Option option = candidate.finishReason().map((Function1 & Serializable)_$14 -> _$14.toString());
            return ChatCompletionChoiceChunkInfo$.MODULE$.apply(chunkMessageSpec, n, option);
        }), (Option)Some$.MODULE$.apply((Object)this.toOpenAIUsage(response.usageMetadata())));
    }

    private AssistantMessage toOpenAIAssistantMessage(Content content) {
        return AssistantMessage$.MODULE$.apply(((IterableOnceOps)content.parts().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Part x) {
                Part part = x;
                if (part instanceof Part.Text) {
                    String string;
                    Part.Text text = Part$Text$.MODULE$.unapply((Part.Text)part);
                    String text2 = string = text._1();
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Part x, Function1 function1) {
                Part part = x;
                if (part instanceof Part.Text) {
                    String string;
                    Part.Text text = Part$Text$.MODULE$.unapply((Part.Text)part);
                    String text2 = string = text._1();
                    return text2;
                }
                throw new OpenAIScalaClientException("Unsupported assistant part type for Gemini. Implement me!");
            }
        })).mkString("\n"), AssistantMessage$.MODULE$.$lessinit$greater$default$2(), AssistantMessage$.MODULE$.$lessinit$greater$default$3());
    }

    private ChunkMessageSpec toOpenAIAssistantChunkMessage(Content content) {
        Seq texts = (Seq)content.parts().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Part x) {
                Part part = x;
                if (part instanceof Part.Text) {
                    String string;
                    Part.Text text = Part$Text$.MODULE$.unapply((Part.Text)part);
                    String text2 = string = text._1();
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Part x, Function1 function1) {
                Part part = x;
                if (part instanceof Part.Text) {
                    String string;
                    Part.Text text = Part$Text$.MODULE$.unapply((Part.Text)part);
                    String text2 = string = text._1();
                    return text2;
                }
                throw new OpenAIScalaClientException("Unsupported assistant part type for Gemini. Implement me!");
            }
        });
        return ChunkMessageSpec$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)ChatRole.Assistant$.MODULE$), (Option)(texts.nonEmpty() ? Some$.MODULE$.apply((Object)texts.mkString("\n")) : None$.MODULE$));
    }

    private UsageInfo toOpenAIUsage(UsageMetadata usageMetadata) {
        return UsageInfo$.MODULE$.apply(usageMetadata.promptTokenCount(), usageMetadata.totalTokenCount(), usageMetadata.candidatesTokenCount(), (Option)Some$.MODULE$.apply((Object)PromptTokensDetails$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)usageMetadata.cachedContentTokenCount().getOrElse(OpenAIGeminiChatCompletionService::toOpenAIUsage$$anonfun$1)), (Option)None$.MODULE$)), UsageInfo$.MODULE$.$lessinit$greater$default$5());
    }

    public void close() {
        this.underlying.close();
    }

    private final Future handleCaching$$anonfun$2(Option systemMessage$1, CreateChatCompletionSettings settings$2) {
        Logger LoggerImpl_this;
        if (CreateChatCompletionSettingsOps$.MODULE$.RichGeminiCreateChatCompletionSettings(settings$2).isCacheSystemMessageEnabled() && systemMessage$1.isDefined()) {
            return this.cacheMessages((BaseMessage)systemMessage$1.get(), (Option<BaseMessage>)None$.MODULE$, settings$2).map((Function1 & Serializable)cacheName -> {
                Logger LoggerImpl_this = this.logger();
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("System message for Gemini cached as: {}", cacheName);
                }
                GenerateContentSettings generateContentSettings = this.toGeminiSettings(settings$2, (Option<BaseMessage>)None$.MODULE$);
                Some some = Some$.MODULE$.apply(cacheName);
                String string = generateContentSettings.copy$default$1();
                Option<Seq<Tool>> option = generateContentSettings.copy$default$2();
                Option<ToolConfig> option2 = generateContentSettings.copy$default$3();
                Option<Seq<SafetySetting>> option3 = generateContentSettings.copy$default$4();
                Option<Content> option4 = generateContentSettings.copy$default$5();
                Option<GenerationConfig> option5 = generateContentSettings.copy$default$6();
                return generateContentSettings.copy(string, option, option2, option3, option4, option5, (Option<String>)some);
            }, this.executionContext);
        }
        if (CreateChatCompletionSettingsOps$.MODULE$.RichGeminiCreateChatCompletionSettings(settings$2).isCacheSystemMessageEnabled() && (LoggerImpl_this = this.logger()).underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("No system message provided for caching.");
        }
        return Future$.MODULE$.successful((Object)this.toGeminiSettings(settings$2, (Option<BaseMessage>)systemMessage$1));
    }

    private static final String $anonfun$2() {
        throw new OpenAIScalaClientException("System message content is missing.");
    }

    private static final Seq $anonfun$5() {
        return package$.MODULE$.Nil();
    }

    private static final /* synthetic */ boolean $anonfun$8(char _$3) {
        return _$3 != ';';
    }

    private static final /* synthetic */ boolean $anonfun$9(char _$4) {
        return _$4 != ',';
    }

    private static final ChatCompletionResponseFormatType $anonfun$10() {
        return ChatCompletionResponseFormatType.text$.MODULE$;
    }

    private final void notSupported$1(CreateChatCompletionSettings settings$4, Function1 field, String fieldName) {
        ((Option)field.apply((Object)settings$4)).foreach((Function1)(JProcedure1 & Serializable)_$5 -> {
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("OpenAI param '{}' is not yet supported by Gemini. Skipping...", (Object)fieldName);
                return;
            }
        });
    }

    private final void notSupportedCollection$1(CreateChatCompletionSettings settings$5, Function1 field, String fieldName) {
        if (((IterableOnceOps)field.apply((Object)settings$5)).nonEmpty()) {
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("OpenAI param '{}' is not yet supported by Gemini. Skipping...", (Object)fieldName);
                return;
            }
            return;
        }
    }

    private static final int $anonfun$12() {
        return 0;
    }

    private static final int $anonfun$14() {
        return 0;
    }

    private static final int toOpenAIUsage$$anonfun$1() {
        return 0;
    }
}

