/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.tracing.receiver.internal;

import io.cellery.observability.tracing.receiver.internal.ZipkinSpan;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;

public class Codec {
    private static final Logger logger = Logger.getLogger((String)Codec.class.getName());

    public static List<ZipkinSpan> decodeData(byte[] byteArray) {
        BytesDecoder spanBytesDecoder = SpanBytesDecoderDetector.decoderForListMessage((byte[])byteArray);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using " + spanBytesDecoder.getClass().getName() + " decoder for received tracing data"));
        }
        List zipkin2Spans = spanBytesDecoder.decodeList(byteArray);
        ArrayList<ZipkinSpan> spans = new ArrayList<ZipkinSpan>();
        for (Span zipkin2Span : zipkin2Spans) {
            ZipkinSpan span = new ZipkinSpan();
            span.setTraceId(zipkin2Span.traceId());
            span.setId(zipkin2Span.id());
            span.setParentId(zipkin2Span.parentId());
            span.setName(zipkin2Span.name());
            span.setServiceName(zipkin2Span.localServiceName() != null ? zipkin2Span.localServiceName() : "");
            span.setKind(zipkin2Span.kind() != null ? zipkin2Span.kind().toString() : "");
            span.setTimestamp(zipkin2Span.timestampAsLong());
            span.setDuration(zipkin2Span.durationAsLong());
            span.setTags(zipkin2Span.tags());
            spans.add(span);
        }
        return spans;
    }

    private Codec() {
    }
}

