/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.k8s.client;

import io.cellery.observability.k8s.client.crds.cell.Cell;
import io.cellery.observability.k8s.client.crds.composite.Composite;
import io.cellery.observability.k8s.client.crds.gateway.Ingress;
import io.cellery.observability.k8s.client.crds.service.Component;
import io.cellery.observability.k8s.client.crds.service.Port;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    static String getComponentName(Pod pod) {
        String componentName = null;
        Map labels = pod.getMetadata().getLabels();
        if (labels.containsKey("observability.mesh.cellery.io/component")) {
            componentName = (String)labels.get("observability.mesh.cellery.io/component");
        } else if (labels.containsKey("observability.mesh.cellery.io/gateway")) {
            componentName = (String)labels.get("observability.mesh.cellery.io/gateway");
        }
        return StringUtils.isNotEmpty((CharSequence)componentName) ? componentName : "";
    }

    static Map<String, Set<String>> getComponentIngressTypes(Cell cell) {
        HashMap<String, Set<String>> componentIngressTypes = new HashMap<String, Set<String>>();
        if (cell.getSpec() != null && cell.getSpec().getComponents() != null && cell.getSpec().getGateway() != null && cell.getSpec().getGateway().getSpec() != null && cell.getSpec().getGateway().getSpec().getIngress() != null) {
            Ingress gatewayIngress = cell.getSpec().getGateway().getSpec().getIngress();
            for (Component component : cell.getSpec().getComponents()) {
                boolean isGrpc;
                boolean isTcp;
                boolean isHttp;
                HashSet<String> ingressTypes = new HashSet<String>();
                String componentName = component.getMetadata().getName();
                if (gatewayIngress.getHttp() != null && (isHttp = gatewayIngress.getHttp().stream().anyMatch(httpIngress -> httpIngress.getDestination().getHost().equals(componentName)))) {
                    boolean isWebCell;
                    boolean bl = isWebCell = gatewayIngress.getExtensions() != null && gatewayIngress.getExtensions().getClusterIngress() != null && StringUtils.isNotEmpty((CharSequence)gatewayIngress.getExtensions().getClusterIngress().getHost());
                    if (isWebCell) {
                        ingressTypes.add("WEB");
                    } else {
                        ingressTypes.add("HTTP");
                    }
                }
                if (gatewayIngress.getTcp() != null && (isTcp = gatewayIngress.getTcp().stream().anyMatch(tcpIngress -> tcpIngress.getDestination().getHost().equals(componentName)))) {
                    ingressTypes.add("TCP");
                }
                if (gatewayIngress.getGrpc() != null && (isGrpc = gatewayIngress.getGrpc().stream().anyMatch(grpcIngress -> grpcIngress.getDestination().getHost().equals(componentName)))) {
                    ingressTypes.add("GRPC");
                }
                componentIngressTypes.put(componentName, ingressTypes);
            }
        }
        return componentIngressTypes;
    }

    static Map<String, Set<String>> getComponentIngressTypes(Composite composite) {
        HashMap<String, Set<String>> componentIngressTypes = new HashMap<String, Set<String>>();
        if (composite.getSpec() != null && composite.getSpec().getComponents() != null) {
            for (Component component : composite.getSpec().getComponents()) {
                HashSet<String> ingressTypes = new HashSet<String>();
                String componentName = component.getMetadata().getName();
                if (component.getSpec() != null && component.getSpec().getPorts() != null) {
                    for (Port port : component.getSpec().getPorts()) {
                        String sanitizedProtocol;
                        String protocol = port.getProtocol();
                        if (protocol == null) continue;
                        switch (sanitizedProtocol = protocol.toUpperCase(Locale.US)) {
                            case "HTTP": 
                            case "TCP": 
                            case "GRPC": {
                                ingressTypes.add(sanitizedProtocol);
                                break;
                            }
                        }
                    }
                }
                componentIngressTypes.put(componentName, ingressTypes);
            }
        }
        return componentIngressTypes;
    }

    private Utils() {
    }
}

