/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.auth.internal;

import io.cellery.observability.auth.AuthProvider;
import io.cellery.observability.auth.AuthUtils;
import io.cellery.observability.auth.CelleryLocalAuthProvider;
import io.cellery.observability.auth.DcrProvider;
import io.cellery.observability.auth.internal.AuthConfig;
import io.cellery.observability.auth.internal.ServiceHolder;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.datasource.core.api.DataSourceService;

@Component(service={AuthServiceComponent.class}, immediate=true)
public class AuthServiceComponent {
    private static final Logger logger = Logger.getLogger(AuthServiceComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        try {
            AuthProvider authProvider;
            AuthUtils.disableSSLVerification();
            DcrProvider dcrProvider = new DcrProvider();
            ServiceHolder.setDcrProvider(dcrProvider);
            Class<?> authProviderClass = Class.forName(AuthConfig.getInstance().getAuthProvider());
            Constructor<?> authProviderConstructor = authProviderClass.getConstructor(new Class[0]);
            Object authProviderObject = authProviderConstructor.newInstance(new Object[0]);
            if (authProviderObject instanceof AuthProvider) {
                authProvider = (AuthProvider)authProviderObject;
                logger.info((Object)("Using " + authProviderClass.getName() + " as the Auth Provider"));
            } else {
                authProvider = new CelleryLocalAuthProvider();
                logger.warn((Object)("Using default Cellery Auth Provider since " + authProviderClass.getName() + " is not an instance of " + AuthProvider.class));
            }
            bundleContext.registerService(DcrProvider.class.getName(), (Object)dcrProvider, null);
            bundleContext.registerService(AuthProvider.class.getName(), (Object)authProvider, null);
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error occurred while activating the model generation bundle", throwable);
            throw throwable;
        }
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigProvider")
    protected void setConfigProvider(ConfigProvider configProvider) {
        ServiceHolder.setConfigProvider(configProvider);
    }

    protected void unsetConfigProvider(ConfigProvider configProvider) {
        ServiceHolder.setConfigProvider(null);
    }

    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceService")
    protected void registerDataSourceService(DataSourceService service) {
        ServiceHolder.setDataSourceService(service);
    }

    protected void unregisterDataSourceService(DataSourceService service) {
        ServiceHolder.setDataSourceService(null);
    }
}

