/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.auth.internal;

import io.cellery.observability.auth.CelleryLocalAuthProvider;
import io.cellery.observability.auth.exception.AuthProviderException;
import io.cellery.observability.auth.internal.ServiceHolder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;

@Configuration(namespace="cellery.observability.auth", description="Cellery Auth Configuration")
public class AuthConfig {
    private static volatile AuthConfig authConfig;
    @Element(description="idpUrl")
    private String idpUrl = "";
    @Element(description="idpUsername")
    private String idpUsername = "";
    @Element(description="idpPassword")
    private String idpPassword = "";
    @Element(description="portalHomeUrl")
    private String portalHomeUrl = "";
    @Element(description="dcrClientId")
    private String dcrClientId = "";
    @Element(description="dcrClientName")
    private String dcrClientName = "";
    @Element(description="idpDcrRegisterEndpoint")
    private String idpDcrRegisterEndpoint = "";
    @Element(description="idpOidcIntrospectEndpoint")
    private String idpOidcIntrospectEndpoint = "";
    @Element(description="idpOidcTokenEndpoint")
    private String idpOidcTokenEndpoint = "";
    @Element(description="authProvider")
    private String authProvider = CelleryLocalAuthProvider.class.getName();
    @Element(description="defaultLocalAuthProviderToken")
    private String defaultLocalAuthProviderToken = "";
    @Element(description="defaultLocalAuthProviderLocalRuntimeId")
    private String defaultLocalAuthProviderLocalRuntimeId = "";

    public String getIdpUrl() {
        return this.idpUrl;
    }

    public String getIdpUsername() {
        return this.idpUsername;
    }

    public String getIdpPassword() {
        return this.idpPassword;
    }

    public String getPortalHomeUrl() {
        return this.portalHomeUrl;
    }

    public String getDcrClientId() {
        return this.dcrClientId;
    }

    public String getDcrClientName() {
        return this.dcrClientName;
    }

    public String getIdpDcrRegisterEndpoint() {
        return this.idpDcrRegisterEndpoint;
    }

    public String getIdpOidcIntrospectEndpoint() {
        return this.idpOidcIntrospectEndpoint;
    }

    public String getIdpOidcTokenEndpoint() {
        return this.idpOidcTokenEndpoint;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public String getDefaultLocalAuthProviderToken() {
        return this.defaultLocalAuthProviderToken;
    }

    public String getDefaultLocalAuthProviderLocalRuntimeId() {
        return this.defaultLocalAuthProviderLocalRuntimeId;
    }

    public static synchronized AuthConfig getInstance() throws ConfigurationException, AuthProviderException {
        if (authConfig == null) {
            authConfig = (AuthConfig)ServiceHolder.getConfigProvider().getConfigurationObject(AuthConfig.class);
            authConfig.validate();
        }
        return authConfig;
    }

    private void validate() throws AuthProviderException {
        if (StringUtils.isEmpty((CharSequence)this.idpUrl)) {
            throw new AuthProviderException("IdP URL provided is empty, expected a proper URL");
        }
        if (StringUtils.isEmpty((CharSequence)this.idpUsername)) {
            throw new AuthProviderException("IdP Username provided is empty, expected a proper username");
        }
        if (StringUtils.isEmpty((CharSequence)this.idpPassword)) {
            throw new AuthProviderException("IdP Password provided is empty, expected a proper password");
        }
        if (StringUtils.isEmpty((CharSequence)this.portalHomeUrl)) {
            throw new AuthProviderException("OIDC callback URL is empty, expected the proper URL used in the auth flows");
        }
        if (StringUtils.isEmpty((CharSequence)this.dcrClientId)) {
            throw new AuthProviderException("DCR Client ID is empty, expected a proper Client ID");
        }
        if (StringUtils.isEmpty((CharSequence)this.dcrClientName)) {
            throw new AuthProviderException("DCR Client Name is empty, expected a proper Client Name");
        }
        if (StringUtils.isEmpty((CharSequence)this.idpDcrRegisterEndpoint)) {
            throw new AuthProviderException("IdP DCR registration endpoint is empty, expected the proper endpoint");
        }
        if (StringUtils.isEmpty((CharSequence)this.idpOidcTokenEndpoint)) {
            throw new AuthProviderException("IdP DCR token endpoint is empty, expected the proper endpoint");
        }
        if (StringUtils.isEmpty((CharSequence)this.idpOidcIntrospectEndpoint)) {
            throw new AuthProviderException("IdP OIDC introspect endpoint is empty, expected the proper endpoint");
        }
        if (Objects.equals(this.authProvider, CelleryLocalAuthProvider.class.getName())) {
            if (StringUtils.isEmpty((CharSequence)this.defaultLocalAuthProviderToken)) {
                throw new AuthProviderException("Default Local Auth Provider Token is empty, expected a proper token");
            }
            if (StringUtils.isEmpty((CharSequence)this.defaultLocalAuthProviderLocalRuntimeId)) {
                throw new AuthProviderException("Default Local Auth Provider Local Runtime ID is empty, expected a proper runtime ID");
            }
        }
    }
}

