/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.auth;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.cellery.observability.auth.AuthUtils;
import io.cellery.observability.auth.exception.AuthProviderException;
import io.cellery.observability.auth.internal.AuthConfig;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.wso2.carbon.config.ConfigurationException;

public class DcrProvider {
    private static final Logger logger = Logger.getLogger(DcrProvider.class);
    private static final Gson gson = new Gson();
    private static final JsonParser jsonParser = new JsonParser();
    private static final String ERROR = "error";
    private String clientId;
    private char[] clientSecret;

    public DcrProvider() {
        try {
            this.retrieveClientCredentials();
        }
        catch (AuthProviderException | ConfigurationException e) {
            logger.warn((Object)"Fetching Client Credentials failed due to IDP unavailability, will be re-attempted when a user logs in", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() throws AuthProviderException, ConfigurationException {
        if (this.clientId == null) {
            DcrProvider dcrProvider = this;
            synchronized (dcrProvider) {
                this.retrieveClientCredentials();
            }
        }
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientSecret() throws AuthProviderException, ConfigurationException {
        if (this.clientSecret == null) {
            DcrProvider dcrProvider = this;
            synchronized (dcrProvider) {
                this.retrieveClientCredentials();
            }
        }
        return String.valueOf(this.clientSecret);
    }

    private void retrieveClientCredentials() throws AuthProviderException, ConfigurationException {
        if (this.clientId == null || this.clientSecret == null) {
            JsonObject jsonObject = this.createNewClient();
            if (jsonObject.has(ERROR)) {
                jsonObject = this.retrieveExistingClientCredentials();
                logger.info((Object)("Fetched the credentials of the already existing client " + AuthConfig.getInstance().getDcrClientName()));
            } else {
                logger.info((Object)("Created new Client " + AuthConfig.getInstance().getDcrClientName()));
            }
            this.clientId = jsonObject.get("client_id").getAsString();
            this.clientSecret = jsonObject.get("client_secret").getAsString().toCharArray();
        }
    }

    private JsonObject createNewClient() throws AuthProviderException {
        try {
            JsonArray callbackUris = new JsonArray(1);
            callbackUris.add(AuthConfig.getInstance().getPortalHomeUrl());
            JsonArray grants = new JsonArray(1);
            grants.add("authorization_code");
            String dcrEp = AuthConfig.getInstance().getIdpUrl() + AuthConfig.getInstance().getIdpDcrRegisterEndpoint();
            JsonObject clientJson = new JsonObject();
            clientJson.addProperty("ext_param_client_id", AuthConfig.getInstance().getDcrClientId());
            clientJson.addProperty("client_name", AuthConfig.getInstance().getDcrClientName());
            clientJson.add("redirect_uris", (JsonElement)callbackUris);
            clientJson.add("grant_types", (JsonElement)grants);
            StringEntity requestEntity = new StringEntity(gson.toJson((JsonElement)clientJson), ContentType.APPLICATION_JSON);
            HttpPost request = new HttpPost(dcrEp);
            request.setHeader("Authorization", AuthUtils.generateBasicAuthHeaderValue(AuthConfig.getInstance().getIdpUsername(), AuthConfig.getInstance().getIdpPassword()));
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)requestEntity);
            HttpClient client = AuthUtils.getTrustAllClient();
            HttpResponse response = client.execute((HttpUriRequest)request);
            return jsonParser.parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | ParseException | ConfigurationException e) {
            throw new AuthProviderException("Error occurred while registering client", e);
        }
    }

    private JsonObject retrieveExistingClientCredentials() throws AuthProviderException, ConfigurationException {
        try {
            String dcrEp = AuthConfig.getInstance().getIdpUrl() + AuthConfig.getInstance().getIdpDcrRegisterEndpoint();
            HttpGet request = new HttpGet(dcrEp + "?" + "client_name" + "=" + AuthConfig.getInstance().getDcrClientName());
            request.setHeader("Authorization", AuthUtils.generateBasicAuthHeaderValue(AuthConfig.getInstance().getIdpUsername(), AuthConfig.getInstance().getIdpPassword()));
            HttpClient client = AuthUtils.getTrustAllClient();
            HttpResponse response = client.execute((HttpUriRequest)request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200 && result.contains("client_id")) {
                return jsonParser.parse(result).getAsJsonObject();
            }
            throw new AuthProviderException("Error while retrieving client credentials. Expected client credentials are not found in the response");
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException | ParseException | ConfigurationException e) {
            throw new AuthProviderException("Error occurred while retrieving the client credentials with name " + AuthConfig.getInstance().getDcrClientName(), e);
        }
    }
}

