/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.auth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.cellery.observability.auth.AuthProvider;
import io.cellery.observability.auth.AuthUtils;
import io.cellery.observability.auth.Permission;
import io.cellery.observability.auth.exception.AuthProviderException;
import io.cellery.observability.auth.internal.AuthConfig;
import io.cellery.observability.auth.internal.ServiceHolder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class CelleryLocalAuthProvider
implements AuthProvider {
    private static final Logger logger = Logger.getLogger(CelleryLocalAuthProvider.class);
    private static final JsonParser jsonParser = new JsonParser();
    private final String localRuntimeId;
    private final DataSource dataSource;
    private static final String ACTIVE_STATUS = "active";
    private static final String TABLE_NAME = "K8sComponentInfoTable";
    private static final String DATASOURCE_NAME = "CELLERY_OBSERVABILITY_DB";
    private static final List<Permission.Action> ALL_ACTIONS = Arrays.asList(Permission.Action.API_GET, Permission.Action.DATA_PUBLISH);

    public CelleryLocalAuthProvider() throws AuthProviderException {
        try {
            this.dataSource = (DataSource)ServiceHolder.getDataSourceService().getDataSource(DATASOURCE_NAME);
            this.localRuntimeId = AuthConfig.getInstance().getDefaultLocalAuthProviderLocalRuntimeId();
        }
        catch (ConfigurationException | DataSourceException e) {
            throw new AuthProviderException("Failed to initialize Cellery Local Auth Provider", e);
        }
    }

    @Override
    public boolean isTokenValid(String token, Permission requiredPermission) throws AuthProviderException {
        if (StringUtils.isBlank((CharSequence)requiredPermission.getRuntime()) || Objects.equals(requiredPermission.getRuntime(), this.localRuntimeId)) {
            List<Permission.Action> actions = requiredPermission.getActions();
            if (actions.size() == 1 && Objects.equals((Object)actions.get(0), (Object)Permission.Action.DATA_PUBLISH)) {
                boolean isAllowed;
                try {
                    isAllowed = Objects.equals(AuthConfig.getInstance().getDefaultLocalAuthProviderToken(), token);
                }
                catch (ConfigurationException e) {
                    logger.error((Object)("Failed to validate data publish request access token from runtime " + requiredPermission.getRuntime()), (Throwable)e);
                    isAllowed = false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)((isAllowed ? "Allowing" : "Blocking") + " data publish request from runtime " + requiredPermission.getRuntime() + " since the token does not match the configured data publish token"));
                }
                return isAllowed;
            }
            boolean isAllowed = this.isTokenValid(token);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((isAllowed ? "Allowing " : "Blocking ") + requiredPermission.getActions().toString() + " for runtime: " + requiredPermission.getRuntime() + ", namespace: " + requiredPermission.getNamespace() + " since the token is invalid"));
            }
            return isAllowed;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Blocking " + requiredPermission.getActions().toString() + " for runtime: " + requiredPermission.getRuntime() + ", namespace: " + requiredPermission.getNamespace() + " since runtime ID does not match " + this.localRuntimeId));
        }
        return false;
    }

    @Override
    public Permission[] getAllAllowedPermissions(String accessToken) {
        Permission[] permissions;
        List<String> namespaces;
        try {
            namespaces = this.getAllNamespaces();
        }
        catch (SQLException e) {
            namespaces = new ArrayList<String>(0);
            logger.error((Object)("Providing no access to any namespace since failure occurred while getting all the namespaces in " + this.localRuntimeId), (Throwable)e);
        }
        if (namespaces.size() > 0) {
            permissions = (Permission[])namespaces.stream().map(namespace -> new Permission(this.localRuntimeId, (String)namespace, ALL_ACTIONS)).toArray(Permission[]::new);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Providing all actions for all namespaces (" + namespaces.size() + ") from " + this.localRuntimeId + " runtime as allowed permissions"));
            }
        } else {
            permissions = new Permission[]{};
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Providing no allowed permissions as no namespaces are present");
            }
        }
        return permissions;
    }

    protected boolean isTokenValid(String token) throws AuthProviderException {
        block4: {
            try {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("token", token));
                String introspectEP = AuthConfig.getInstance().getIdpUrl() + AuthConfig.getInstance().getIdpOidcIntrospectEndpoint();
                HttpPost request = new HttpPost(introspectEP);
                request.setHeader("Authorization", AuthUtils.generateBasicAuthHeaderValue(AuthConfig.getInstance().getIdpUsername(), AuthConfig.getInstance().getIdpPassword()));
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8.name()));
                HttpClient client = AuthUtils.getTrustAllClient();
                HttpResponse response = client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 400) {
                    JsonObject jsonObject = jsonParser.parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
                    if (!jsonObject.get(ACTIVE_STATUS).getAsBoolean()) {
                        return false;
                    }
                    break block4;
                }
                logger.error((Object)("Failed to validate whether the token is valid with status code " + statusCode));
                return false;
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException | ParseException | ConfigurationException e) {
                throw new AuthProviderException("Error occurred while calling the introspect endpoint", e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllNamespaces() throws SQLException {
        ArrayList<String> namespaces = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("SELECT DISTINCT namespace FROM K8sComponentInfoTable WHERE runtime = ?");
            statement.setString(1, this.localRuntimeId);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String runtime = resultSet.getString(1);
                namespaces.add(runtime);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error on closing resultSet " + e.getMessage()), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error on closing statement " + e.getMessage()), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("Error on closing connection " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return namespaces;
    }
}

