/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.auth;

import io.cellery.observability.auth.exception.AuthProviderException;
import io.cellery.observability.auth.internal.AuthConfig;
import io.cellery.observability.auth.internal.ServiceHolder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.wso2.carbon.config.ConfigurationException;

public class AuthUtils {
    private static final String BASIC_AUTH_PREFIX = "Basic ";

    public static org.apache.http.client.HttpClient getTrustAllClient() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, trustManagers, null);
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(context, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        PlainConnectionSocketFactory plainConnectionSocketFactory = new PlainConnectionSocketFactory();
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)plainConnectionSocketFactory).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).setConnectionManager((HttpClientConnectionManager)ccm).build();
    }

    public static void disableSSLVerification() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagers, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((string, sslSession) -> true);
    }

    public static OAuthAccessTokenResponse exchangeAuthCode(String authCode) throws AuthProviderException, ConfigurationException, OAuthSystemException, OAuthProblemException {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)(AuthConfig.getInstance().getIdpUrl() + AuthConfig.getInstance().getIdpOidcTokenEndpoint())).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(ServiceHolder.getDcrProvider().getClientId()).setClientSecret(ServiceHolder.getDcrProvider().getClientSecret()).setRedirectURI(AuthConfig.getInstance().getPortalHomeUrl()).setCode(authCode).buildBodyMessage();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        return oAuthClient.accessToken(oAuthClientRequest);
    }

    public static String generateBasicAuthHeaderValue(String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes(Charset.forName(StandardCharsets.UTF_8.name())));
        return BASIC_AUTH_PREFIX + new String(authEncBytes, Charset.forName(StandardCharsets.UTF_8.name()));
    }

    private AuthUtils() {
    }
}

