/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.test;

import com.google.common.collect.Lists;
import io.castled.commons.streams.RecordInputStream;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Schema;
import io.castled.schema.models.StringSchema;
import io.castled.schema.models.Tuple;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class DummyRecordInputStream
implements RecordInputStream {
    private List<String> emails = Lists.newArrayList((Object[])new String[]{"arun@gmail.com", "frank@gmail.com"});
    private List<String> firstNames = Lists.newArrayList((Object[])new String[]{"Arun", "Frank"});
    private List<String> lastNames = Lists.newArrayList((Object[])new String[]{"TG", "GV"});
    private List<String> lifeCycleStages = Lists.newArrayList((Object[])new String[]{"lead", "subscriber"});
    private int readTill = -1;
    private final RecordSchema schema;

    public DummyRecordInputStream() {
        StringSchema stringSchema = StringSchema.builder().optional(true).maxLength(64).build();
        this.schema = RecordSchema.builder().name("Ticket").put("email", (Schema)stringSchema).put("first_name", (Schema)stringSchema).put("last_name", (Schema)stringSchema).put("lifecycle_stage", (Schema)stringSchema).build();
    }

    @Override
    public Tuple readRecord() {
        if (this.readTill + 1 >= this.emails.size()) {
            return null;
        }
        Date date = Date.from(LocalDate.of(2017, Month.FEBRUARY, 12).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant());
        Tuple.Builder recordBuilder = Tuple.builder();
        for (FieldSchema fieldSchema : this.schema.getFieldSchemas()) {
            recordBuilder.put(fieldSchema, (Object)this.emails.get(this.readTill + 1));
            ++this.readTill;
        }
        return recordBuilder.build();
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

