/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.redshift;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.constants.ConnectorExecutionConstants;
import io.castled.exceptions.connect.ConnectException;
import io.castled.exceptions.connect.ConnectionError;
import io.castled.jdbc.JdbcConnectionManager;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.models.QueryResults;
import io.castled.schema.ResultSetSchemaMapper;
import io.castled.schema.models.RecordSchema;
import io.castled.warehouses.TableProperties;
import io.castled.warehouses.WarehouseDataPoller;
import io.castled.warehouses.WarehouseSyncFailureListener;
import io.castled.warehouses.connectors.redshift.RedshiftClient;
import io.castled.warehouses.connectors.redshift.RedshiftDataPoller;
import io.castled.warehouses.connectors.redshift.RedshiftSyncFailureListener;
import io.castled.warehouses.connectors.redshift.RedshiftTableProperties;
import io.castled.warehouses.connectors.redshift.RedshiftWarehouseConfig;
import io.castled.warehouses.jdbc.JdbcWarehouseConnector;
import io.castled.warehouses.models.WarehousePollContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;

@Singleton
public class RedshiftConnector
extends JdbcWarehouseConnector<RedshiftWarehouseConfig> {
    private final RedshiftDataPoller redshiftDataPoller;
    private final ResultSetSchemaMapper resultSetSchemaMapper;
    private final RedshiftClient redshiftClient;

    @Inject
    public RedshiftConnector(RedshiftDataPoller redshiftDataPoller, ResultSetSchemaMapper resultSetSchemaMapper, RedshiftClient redshiftClient) {
        this.redshiftDataPoller = redshiftDataPoller;
        this.resultSetSchemaMapper = resultSetSchemaMapper;
        this.redshiftClient = redshiftClient;
    }

    @Override
    public Connection getConnection(RedshiftWarehouseConfig config) throws SQLException {
        JdbcConnectionManager jdbcConnectionManager = (JdbcConnectionManager)ObjectRegistry.getInstance(JdbcConnectionManager.class);
        return jdbcConnectionManager.getTunneledConnection(this.getConnectionType(), config.getDbUser(), config.getDbPassword(), config.getDbName(), null, config.getServerHost(), config.getServerPort(), config.getSSHTunnelParams(), new Properties());
    }

    @Override
    public void testConnectionForDataPoll(RedshiftWarehouseConfig config) throws ConnectException {
        try (Connection connection = this.getConnection(config);){
            List<String> schemas = this.redshiftClient.listSchemas(connection);
            if (!schemas.contains("castled")) {
                throw new ConnectException(ConnectionError.INCOMPLETE_SETUP, String.format("%s schema does not exist. Please create the castled schema as mentioned in our doc", "castled"));
            }
        }
        catch (Exception e) {
            throw new ConnectException(ConnectionError.UNKNOWN, Optional.ofNullable(e.getMessage()).orElse("Unknown Error"));
        }
    }

    @Override
    public WarehouseDataPoller getDataPoller() {
        return this.redshiftDataPoller;
    }

    @Override
    public RecordSchema getQuerySchema(RedshiftWarehouseConfig redshiftWarehouseConfig, String query) throws Exception {
        try (Connection connection = this.getConnection(redshiftWarehouseConfig);){
            RecordSchema recordSchema;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(query);
                try {
                    recordSchema = this.resultSetSchemaMapper.getSchema(preparedStatement.getMetaData());
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return recordSchema;
        }
    }

    @Override
    public WarehouseSyncFailureListener syncFailureListener(WarehousePollContext warehousePollContext) {
        return new RedshiftSyncFailureListener(warehousePollContext);
    }

    @Override
    public TableProperties getSnapshotTableProperties(List<String> recordIdKeys) {
        if (CollectionUtils.isEmpty(recordIdKeys) || recordIdKeys.size() > 1) {
            return new RedshiftTableProperties(null, null);
        }
        return new RedshiftTableProperties(recordIdKeys, recordIdKeys.get(0));
    }

    @Override
    public void restartPoll(String pipelineUUID, RedshiftWarehouseConfig redshiftWarehouseConfig) throws Exception {
        try (Connection connection = this.getConnection(redshiftWarehouseConfig);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("drop table if exists %s", ConnectorExecutionConstants.getQualifiedCommittedSnapshot(pipelineUUID)));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public QueryResults previewQuery(String query, RedshiftWarehouseConfig redshiftWarehouseConfig, int maxRows) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public JdbcConnectionType getConnectionType() {
        return JdbcConnectionType.REDSHIFT;
    }

    @Override
    public Class<RedshiftWarehouseConfig> getConfigType() {
        return RedshiftWarehouseConfig.class;
    }

    @Override
    public RedshiftWarehouseConfig filterRestrictedConfigDetails(RedshiftWarehouseConfig redshiftWarehouseConfig) {
        redshiftWarehouseConfig.setDbPassword(null);
        return redshiftWarehouseConfig;
    }
}

