/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.postgres;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.ObjectRegistry;
import io.castled.constants.ConnectorExecutionConstants;
import io.castled.exceptions.connect.ConnectException;
import io.castled.exceptions.connect.ConnectionError;
import io.castled.jdbc.JdbcConnectionManager;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.models.QueryResults;
import io.castled.schema.models.RecordSchema;
import io.castled.warehouses.TableProperties;
import io.castled.warehouses.WarehouseDataPoller;
import io.castled.warehouses.WarehouseSyncFailureListener;
import io.castled.warehouses.connectors.postgres.PostgresClient;
import io.castled.warehouses.connectors.postgres.PostgresDataPoller;
import io.castled.warehouses.connectors.postgres.PostgresResultSetSchemaMapper;
import io.castled.warehouses.connectors.postgres.PostgresSyncFailureListener;
import io.castled.warehouses.connectors.postgres.PostgresTableProperties;
import io.castled.warehouses.connectors.postgres.PostgresWarehouseConfig;
import io.castled.warehouses.jdbc.JdbcWarehouseConnector;
import io.castled.warehouses.models.WarehousePollContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

@Singleton
public class PostgresWarehouseConnector
extends JdbcWarehouseConnector<PostgresWarehouseConfig> {
    private final PostgresResultSetSchemaMapper resultSetSchemaMapper;
    private final JdbcConnectionManager jdbcConnectionManager;
    private final PostgresClient postgresClient;

    @Inject
    public PostgresWarehouseConnector(PostgresResultSetSchemaMapper resultSetSchemaMapper, JdbcConnectionManager jdbcConnectionManager, PostgresClient postgresClient) {
        this.resultSetSchemaMapper = resultSetSchemaMapper;
        this.jdbcConnectionManager = jdbcConnectionManager;
        this.postgresClient = postgresClient;
    }

    @Override
    public Class<PostgresWarehouseConfig> getConfigType() {
        return PostgresWarehouseConfig.class;
    }

    @Override
    public TableProperties getSnapshotTableProperties(List<String> recordIdKeys) {
        return new PostgresTableProperties(recordIdKeys);
    }

    @Override
    public void testConnectionForDataPoll(PostgresWarehouseConfig config) throws ConnectException {
        try (Connection connection = this.getConnection(config);){
            List<String> schemas = this.postgresClient.listSchemas(connection);
            if (!schemas.contains("castled")) {
                throw new ConnectException(ConnectionError.INCOMPLETE_SETUP, String.format("%s schema does not exist or the user does not have sufficient permissions to access it.Please create the castled schema and/or give relevant permissions as mentioned in our doc", "castled"));
            }
        }
        catch (Exception e) {
            throw new ConnectException(ConnectionError.UNKNOWN, Optional.ofNullable(e.getMessage()).orElse("Unknown Error"));
        }
    }

    @Override
    public Connection getConnection(PostgresWarehouseConfig config) throws SQLException {
        return this.jdbcConnectionManager.getTunneledConnection(this.getConnectionType(), config.getDbUser(), config.getDbPassword(), config.getDbName(), null, config.getServerHost(), config.getServerPort(), config.getSSHTunnelParams(), new Properties());
    }

    @Override
    public JdbcConnectionType getConnectionType() {
        return JdbcConnectionType.POSTGRES;
    }

    @Override
    public WarehouseDataPoller getDataPoller() {
        return (WarehouseDataPoller)ObjectRegistry.getInstance(PostgresDataPoller.class);
    }

    @Override
    public RecordSchema getQuerySchema(PostgresWarehouseConfig postgresWarehouseConfig, String query) throws Exception {
        try (Connection connection = this.getConnection(postgresWarehouseConfig);){
            RecordSchema recordSchema;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(query);
                try {
                    recordSchema = this.resultSetSchemaMapper.getSchema(preparedStatement.getMetaData());
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return recordSchema;
        }
    }

    @Override
    public WarehouseSyncFailureListener syncFailureListener(WarehousePollContext warehousePollContext) throws Exception {
        return new PostgresSyncFailureListener(warehousePollContext);
    }

    @Override
    public void restartPoll(String pipelineUUID, PostgresWarehouseConfig postgresWarehouseConfig) throws Exception {
        try (Connection connection = this.getConnection(postgresWarehouseConfig);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("drop table if exists %s", ConnectorExecutionConstants.getQualifiedCommittedSnapshot(pipelineUUID)));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public QueryResults previewQuery(String query, PostgresWarehouseConfig postgresWarehouseConfig, int maxRows) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PostgresWarehouseConfig filterRestrictedConfigDetails(PostgresWarehouseConfig postgresWarehouseConfig) {
        postgresWarehouseConfig.setDbPassword(null);
        postgresWarehouseConfig.setPrivateKey(null);
        return postgresWarehouseConfig;
    }
}

