/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.bigquery.daos;

import io.castled.warehouses.connectors.bigquery.BQSnapshotTracker;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterRowMapper(value=BQSnapshotTrackerRowMapper.class)
public interface BQSnapshotTrackerDAO {
    @GetGeneratedKeys
    @SqlUpdate(value="insert into bq_snapshot_tracker(pipeline_id, committed, uncommitted) values(:pipelineUUID, :committed, :uncommitted)")
    public long createPipelineSnapshot(@Bind(value="pipelineUUID") String var1, @Bind(value="committed") String var2, @Bind(value="uncommitted") String var3);

    @SqlQuery(value="select * from bq_snapshot_tracker where pipeline_id = :pipelineUUID")
    public BQSnapshotTracker getSnapshotTracker(@Bind(value="pipelineUUID") String var1);

    @SqlUpdate(value="update bq_snapshot_tracker set uncommitted = :uncommitted where pipeline_id = :pipelineUUID")
    public int updateUncommittedSnapshot(@Bind(value="pipelineUUID") String var1, @Bind(value="uncommitted") String var2);

    @SqlUpdate(value="update bq_snapshot_tracker set committed = uncommitted, uncommitted = NULL where pipeline_id = :pipelineUUID")
    public int commitSnapshot(@Bind(value="pipelineUUID") String var1);

    public static class BQSnapshotTrackerRowMapper
    implements RowMapper<BQSnapshotTracker> {
        public BQSnapshotTracker map(ResultSet rs, StatementContext ctx) throws SQLException {
            return BQSnapshotTracker.builder().id(rs.getLong("id")).pipelineUUID(rs.getString("pipeline_id")).committedSnapshot(rs.getString("committed")).uncommittedSnapshot(rs.getString("uncommitted")).build();
        }
    }
}

