/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses.connectors.bigquery;

import io.castled.forms.StaticOptionsFetcher;
import io.castled.forms.dtos.FormFieldOption;
import io.castled.warehouses.connectors.bigquery.GCPRegions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang.WordUtils;

@Singleton
public class BQLocationsFetcher
implements StaticOptionsFetcher {
    public List<FormFieldOption> getOptions() {
        return Arrays.stream(GCPRegions.values()).map(gcpRegion -> new FormFieldOption((Object)gcpRegion.getRegionName(), String.format("%s (%s)", this.normalizeRegion(gcpRegion.name()), gcpRegion.getRegionName()))).collect(Collectors.toList());
    }

    private String normalizeRegion(String name) {
        return WordUtils.capitalizeFully((String)name.replaceAll("_", " "));
    }
}

