/*
 * Decompiled with CFR 0.152.
 */
package io.castled.warehouses;

import com.google.common.collect.Lists;
import io.castled.commons.models.FileStorageNamespace;
import io.castled.filestorage.CastledS3Client;
import io.castled.utils.FileUtils;
import io.castled.warehouses.WarehouseConfig;
import io.castled.warehouses.WarehouseDataPoller;
import io.castled.warehouses.models.WarehousePollContext;
import java.nio.file.Path;

public abstract class S3BasedDataPoller
implements WarehouseDataPoller {
    @Override
    public void cleanupPipelineRunResources(WarehousePollContext warehousePollContext) {
        CastledS3Client castledS3Client = this.getS3Client(warehousePollContext.getWarehouseConfig(), warehousePollContext.getDataEncryptionKey());
        castledS3Client.deleteDirectory(this.getS3UnloadDirectory(warehousePollContext.getPipelineUUID(), warehousePollContext.getPipelineRunId()));
        FileUtils.deleteDirectory((Path)this.getPipelineRunUnloadDirectory(warehousePollContext.getPipelineUUID(), warehousePollContext.getPipelineRunId()));
    }

    public String getS3UnloadDirectory(String pipelineUUID, Long pipelineRunId) {
        return CastledS3Client.constructObjectKey(Lists.newArrayList((Object[])new String[]{FileStorageNamespace.PIPELINE_UNLOADS.getNamespace(), pipelineUUID, String.valueOf(pipelineRunId)}));
    }

    public abstract CastledS3Client getS3Client(WarehouseConfig var1, String var2);
}

