/*
 * Decompiled with CFR 0.152.
 */
package io.castled.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.cache.OAuthCache;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.oauth.OAuthState;
import io.castled.utils.JsonUtils;
import java.util.Optional;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Singleton
public class OAuthService {
    private static final Logger log = LoggerFactory.getLogger(OAuthService.class);
    private static final String OAUTH_NS = "oauth:";
    private final OAuthDAO oAuthDAO;
    private final OAuthCache oAuthCache;
    private final JedisPool jedisPool;

    @Inject
    public OAuthService(Jdbi jdbi, JedisPool jedisPool, OAuthCache oAuthCache) {
        this.oAuthDAO = (OAuthDAO)jdbi.onDemand(OAuthDAO.class);
        this.jedisPool = jedisPool;
        this.oAuthCache = oAuthCache;
    }

    private OAuthState getOAuthState(String stateId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String stateJson = jedis.get(OAUTH_NS + stateId);
            OAuthState oAuthState = Optional.ofNullable(stateJson).map(jsonRef -> (OAuthState)JsonUtils.jsonStringToObject((String)jsonRef, OAuthState.class)).orElse(null);
            return oAuthState;
        }
    }

    public OAuthDetails getOAuthDetails(Long oAuthId, boolean cached) {
        if (cached) {
            return (OAuthDetails)this.oAuthCache.getValue(oAuthId);
        }
        return this.oAuthDAO.getOAuthDetails(oAuthId);
    }

    public OAuthDetails getOAuthDetails(Long oAuthId) {
        return this.getOAuthDetails(oAuthId, false);
    }
}

