/*
 * Decompiled with CFR 0.152.
 */
package io.castled.oauth;

import com.google.inject.Singleton;
import io.castled.oauth.OAuthAccessConfig;
import io.castled.oauth.OAuthDetails;
import io.castled.utils.JsonUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@Singleton
@RegisterRowMapper(value=OauthRowMapper.class)
@RegisterArgumentFactory(value=OAuthConfigArgumentFactory.class)
public interface OAuthDAO {
    @SqlUpdate(value="insert into oauth_details(provider, config) values(:oauth.accessConfig.provider, :oauth.accessConfig)")
    @GetGeneratedKeys
    public long createOAuthDetails(@BindBean(value="oauth") OAuthDetails var1);

    @SqlQuery(value="select * from oauth_details where id = :id")
    public OAuthDetails getOAuthDetails(@Bind(value="id") Long var1);

    @SqlUpdate(value="update oauth_details set config = :config where id = :id")
    public void updateAccessConfig(@Bind(value="id") Long var1, @Bind(value="config") OAuthAccessConfig var2);

    public static class OauthRowMapper
    implements RowMapper<OAuthDetails> {
        public OAuthDetails map(ResultSet rs, StatementContext ctx) throws SQLException {
            OAuthAccessConfig providerConfig = (OAuthAccessConfig)JsonUtils.jsonStringToObject((String)rs.getString("config"), OAuthAccessConfig.class);
            return OAuthDetails.builder().id(rs.getLong("id")).accessConfig(providerConfig).build();
        }
    }

    public static class OAuthConfigArgumentFactory
    extends AbstractArgumentFactory<OAuthAccessConfig> {
        public OAuthConfigArgumentFactory() {
            super(12);
        }

        public Argument build(OAuthAccessConfig oauthAccessConfig, ConfigRegistry config) {
            return (position, statement, ctx) -> statement.setString(position, JsonUtils.objectToString((Object)oauthAccessConfig));
        }
    }
}

