/*
 * Decompiled with CFR 0.152.
 */
package io.castled.jdbc;

import com.jcraft.jsch.JSchException;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.jdbc.JdbcConnectionType;
import io.castled.jdbc.JdbcQueryHelper;
import io.castled.tunnel.HostAndPort;
import io.castled.tunnel.SSHSessionRef;
import io.castled.tunnel.SSHTunnelManager;
import io.castled.tunnel.SSHTunnelParams;
import io.castled.utils.TimeUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JdbcConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnectionManager.class);
    private static final String DB_USER_PROPERTY = "user";
    private static final String DB_PASSWORD_PROPERTY = "password";
    private final Map<JdbcConnectionType, JdbcQueryHelper> queryHelpers;
    private final SSHTunnelManager sshTunnelManager;

    @Inject
    public JdbcConnectionManager(Map<JdbcConnectionType, JdbcQueryHelper> queryHelpers, SSHTunnelManager sshTunnelManager) {
        this.queryHelpers = queryHelpers;
        this.sshTunnelManager = sshTunnelManager;
    }

    public Connection getConnection(JdbcConnectionType jdbcConnectionType, String user, String pass, String database, String schema, String server, int port) throws SQLException {
        return this.getTunneledConnection(jdbcConnectionType, user, pass, database, schema, server, port, null, null);
    }

    public Connection getTunneledConnection(JdbcConnectionType jdbcConnectionType, String user, String pass, String database, String schema, String server, int port, SSHTunnelParams sshTunnelParams, Properties connProperties) throws SQLException {
        try {
            JdbcQueryHelper jdbcQueryHelper = this.queryHelpers.get((Object)jdbcConnectionType);
            SSHSessionRef sshSessionRef = SSHSessionRef.builder().remoteHost(server).remotePort(port).sshTunnelParams(sshTunnelParams).build();
            HostAndPort tunneledHostAndPort = this.sshTunnelManager.getTunneledHostAndPort(sshSessionRef);
            String url = jdbcQueryHelper.constructJdbcUrl(tunneledHostAndPort.getHost(), tunneledHostAndPort.getPort(), database);
            DriverManager.setLoginTimeout((int)TimeUtils.minutesToSeconds((long)1L));
            if (connProperties == null) {
                connProperties = new Properties();
            }
            connProperties.put(DB_USER_PROPERTY, user);
            connProperties.put(DB_PASSWORD_PROPERTY, pass);
            Connection connection = DriverManager.getConnection(url, connProperties);
            connection.setSchema(schema);
            return connection;
        }
        catch (JSchException e) {
            log.error("Established tunneled connected failed for server {} and port {}", (Object)server, (Object)port);
            throw new CastledRuntimeException((Throwable)e);
        }
    }
}

