/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.commons.models.FileFormat;
import io.castled.commons.streams.FileRecordInputStream;
import io.castled.commons.streams.FileRecordInputStreamFactory;
import io.castled.commons.streams.RecordInputStream;
import io.castled.commons.streams.VoidRecordInputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.filestorage.CastledS3Client;
import io.castled.schema.SchemaMapper;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import io.castled.utils.FileUtils;
import io.castled.utils.SizeUtils;
import io.castled.warehouses.connectors.redshift.models.S3PolledFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FilesRecordInputStream
implements RecordInputStream {
    private static final Logger log = LoggerFactory.getLogger(S3FilesRecordInputStream.class);
    private final List<S3PolledFile> s3PolledFiles;
    private final SchemaMapper schemaMapper;
    private final RecordSchema schema;
    private final FileRecordInputStreamFactory fileInputStreamFactory;
    private final Path unloadDirectory;
    private final int diskSpaceThresholdGBs;
    private final FileFormat fileFormat;
    private final CastledS3Client castledS3Client;
    private final boolean gzipped;
    private FileRecordInputStream currentInputStream;
    private int bufferedTill = -1;
    private List<Path> bufferedFiles = Lists.newArrayList();
    private int readTill = -1;

    public S3FilesRecordInputStream(RecordSchema schema, SchemaMapper schemaMapper, List<S3PolledFile> s3PolledFiles, CastledS3Client castledS3Client, FileFormat fileFormat, Path unloadDirectory, int diskSpaceThresholdGBs, boolean gzipped) throws IOException {
        this.s3PolledFiles = s3PolledFiles;
        this.schemaMapper = schemaMapper;
        this.schema = schema;
        this.fileInputStreamFactory = (FileRecordInputStreamFactory)ObjectRegistry.getInstance(FileRecordInputStreamFactory.class);
        this.unloadDirectory = unloadDirectory;
        this.diskSpaceThresholdGBs = diskSpaceThresholdGBs;
        this.castledS3Client = castledS3Client;
        this.fileFormat = fileFormat;
        FileUtils.deleteDirectory((Path)unloadDirectory);
        Files.createDirectories(unloadDirectory, new FileAttribute[0]);
        this.currentInputStream = new VoidRecordInputStream();
        this.gzipped = gzipped;
    }

    @Override
    public Tuple readRecord() {
        try {
            Tuple record;
            while ((record = this.currentInputStream.readRecord()) == null) {
                if (this.currentInputStream.getFilePath() != null) {
                    Files.deleteIfExists(this.currentInputStream.getFilePath());
                }
                this.currentInputStream = this.refreshInputStream();
                if (this.currentInputStream != null) continue;
                return null;
            }
            return record;
        }
        catch (Exception e) {
            log.error("S3 Record file stream failed", (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    private FileRecordInputStream refreshInputStream() throws IOException {
        if (this.readTill + 1 >= this.bufferedFiles.size()) {
            if (this.bufferedTill + 1 >= this.s3PolledFiles.size()) {
                return null;
            }
            this.bufferedFiles.clear();
            this.readTill = -1;
            List<String> objectsToDownload = this.getObjectsToDownload();
            this.bufferedFiles = this.castledS3Client.downloadFiles(objectsToDownload, this.unloadDirectory);
            this.bufferedTill += objectsToDownload.size();
        }
        ++this.readTill;
        return this.fileInputStreamFactory.getRecordInputStream(this.fileFormat, this.bufferedFiles.get(this.readTill), this.schema, this.schemaMapper, this.gzipped);
    }

    private List<String> getObjectsToDownload() {
        ArrayList objectsToDownload = Lists.newArrayList();
        long totalSize = 0L;
        for (int i = this.bufferedTill + 1; i < this.s3PolledFiles.size(); ++i) {
            totalSize += this.s3PolledFiles.get(i).getContentLength();
            if (CollectionUtils.isEmpty((Collection)objectsToDownload)) {
                objectsToDownload.add(this.s3PolledFiles.get(i).getObjectKey());
                continue;
            }
            if (totalSize > SizeUtils.convertGBToBytes((long)this.diskSpaceThresholdGBs)) break;
            objectsToDownload.add(this.s3PolledFiles.get(i).getObjectKey());
        }
        return objectsToDownload;
    }
}

