/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.commons.streams.FileRecordInputStream;
import io.castled.exceptions.CastledException;
import io.castled.schema.IncompatibleValueException;
import io.castled.schema.SchemaMapper;
import io.castled.schema.models.FieldSchema;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import io.castled.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileRecordInputStream
implements FileRecordInputStream {
    private static final Logger log = LoggerFactory.getLogger(JsonFileRecordInputStream.class);
    private final Path filePath;
    private final SchemaMapper schemaMapper;
    private final RecordSchema recordSchema;
    private final BufferedReader bufferedReader;

    public JsonFileRecordInputStream(Path filePath, SchemaMapper schemaMapper, RecordSchema recordSchema, boolean gzipped) throws IOException {
        this.filePath = filePath;
        this.schemaMapper = schemaMapper;
        this.recordSchema = recordSchema;
        this.bufferedReader = gzipped ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filePath.toFile())))) : new BufferedReader(new InputStreamReader(new FileInputStream(filePath.toFile())));
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public Tuple readRecord() throws Exception {
        String jsonRecord = this.bufferedReader.readLine();
        if (jsonRecord == null) {
            return null;
        }
        try {
            Map record = JsonUtils.jsonStringToMap((String)jsonRecord);
            Tuple.Builder recordBuilder = Tuple.builder();
            for (FieldSchema fieldSchema : this.recordSchema.getFieldSchemas()) {
                recordBuilder.put(fieldSchema, this.schemaMapper.transformValue(record.get(fieldSchema.getName()), fieldSchema.getSchema()));
            }
            return recordBuilder.build();
        }
        catch (IncompatibleValueException e) {
            log.error("Failed to read json record in file {}", (Object)this.filePath.toString(), (Object)e);
            throw new CastledException((Throwable)e);
        }
    }
}

