/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import com.google.cloud.storage.Blob;
import com.google.common.collect.Lists;
import io.castled.ObjectRegistry;
import io.castled.commons.models.FileFormat;
import io.castled.commons.streams.FileRecordInputStream;
import io.castled.commons.streams.FileRecordInputStreamFactory;
import io.castled.commons.streams.RecordInputStream;
import io.castled.commons.streams.VoidRecordInputStream;
import io.castled.exceptions.CastledRuntimeException;
import io.castled.filestorage.GcsClient;
import io.castled.schema.SchemaMapper;
import io.castled.schema.models.RecordSchema;
import io.castled.schema.models.Tuple;
import io.castled.utils.SizeUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsFilesRecordInputStream
implements RecordInputStream {
    private static final Logger log = LoggerFactory.getLogger(GcsFilesRecordInputStream.class);
    private final List<Blob> gcsBlobs;
    private final SchemaMapper schemaMapper;
    private final RecordSchema schema;
    private final FileRecordInputStreamFactory fileInputStreamFactory;
    private final Path unloadDirectory;
    private final int diskSpaceThresholdGBs;
    private final FileFormat fileFormat;
    private final GcsClient gcsClient;
    private final boolean gzipped;
    private FileRecordInputStream currentInputStream;
    private int bufferedTill = -1;
    private List<Path> bufferedFiles = Lists.newArrayList();
    private int readTill = -1;

    public GcsFilesRecordInputStream(RecordSchema schema, SchemaMapper schemaMapper, List<Blob> gcsBlobs, FileFormat fileFormat, Path unloadDirectory, GcsClient gcsClient, int diskSpaceThresholdGBs, boolean gzipped) throws IOException {
        this.schemaMapper = schemaMapper;
        this.schema = schema;
        this.fileInputStreamFactory = (FileRecordInputStreamFactory)ObjectRegistry.getInstance(FileRecordInputStreamFactory.class);
        this.unloadDirectory = unloadDirectory;
        this.diskSpaceThresholdGBs = diskSpaceThresholdGBs;
        this.gcsClient = gcsClient;
        this.fileFormat = fileFormat;
        this.gcsBlobs = gcsBlobs;
        if (!Files.exists(unloadDirectory, new LinkOption[0])) {
            Files.createDirectories(unloadDirectory, new FileAttribute[0]);
        }
        this.currentInputStream = new VoidRecordInputStream();
        this.gzipped = gzipped;
    }

    @Override
    public Tuple readRecord() {
        try {
            Tuple record;
            while ((record = this.currentInputStream.readRecord()) == null) {
                if (this.currentInputStream.getFilePath() != null) {
                    Files.deleteIfExists(this.currentInputStream.getFilePath());
                }
                this.currentInputStream = this.refreshInputStream();
                if (this.currentInputStream != null) continue;
                return null;
            }
            return record;
        }
        catch (Exception e) {
            log.error("Gcs record file stream parsing failed", (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    private FileRecordInputStream refreshInputStream() throws IOException {
        if (this.readTill + 1 >= this.bufferedFiles.size()) {
            if (this.bufferedTill + 1 >= this.gcsBlobs.size()) {
                return null;
            }
            this.bufferedFiles.clear();
            this.readTill = -1;
            List<Blob> objectsToDownload = this.getObjectsToDownload();
            this.bufferedFiles = this.gcsClient.downloadFiles(objectsToDownload, this.unloadDirectory);
            this.bufferedTill += objectsToDownload.size();
        }
        ++this.readTill;
        return this.fileInputStreamFactory.getRecordInputStream(this.fileFormat, this.bufferedFiles.get(this.readTill), this.schema, this.schemaMapper, this.gzipped);
    }

    private List<Blob> getObjectsToDownload() {
        ArrayList objectsToDownload = Lists.newArrayList();
        long totalSize = 0L;
        for (int i = this.bufferedTill + 1; i < this.gcsBlobs.size(); ++i) {
            totalSize += this.gcsBlobs.get(i).getSize().longValue();
            if (CollectionUtils.isEmpty((Collection)objectsToDownload)) {
                objectsToDownload.add(this.gcsBlobs.get(i));
                continue;
            }
            if (totalSize > SizeUtils.convertGBToBytes((long)this.diskSpaceThresholdGBs)) break;
            objectsToDownload.add(this.gcsBlobs.get(i));
        }
        return objectsToDownload;
    }
}

