/*
 * Decompiled with CFR 0.152.
 */
package io.castled.commons.streams;

import io.castled.commons.errors.CastledError;
import io.castled.commons.errors.CastledErrorTracker;
import io.castled.commons.models.DataSinkMessage;
import io.castled.commons.streams.DataSinkMessageOutputStream;
import io.castled.exceptions.CastledRuntimeException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ErrorOutputStream.class);
    private final DataSinkMessageOutputStream dataSinkMessageOutputStream;
    private final CastledErrorTracker castledErrorTracker;
    private final AtomicLong failedRecords = new AtomicLong(0L);
    private volatile Long firstFailedMessageId;

    public ErrorOutputStream(DataSinkMessageOutputStream dataSinkMessageOutputStream, CastledErrorTracker castledErrorTracker) {
        this.dataSinkMessageOutputStream = dataSinkMessageOutputStream;
        this.castledErrorTracker = castledErrorTracker;
    }

    public void writeFailedRecord(DataSinkMessage dataSinkMessage, CastledError pipelineError) {
        try {
            if (this.firstFailedMessageId == null) {
                this.firstFailedMessageId = dataSinkMessage.getOffset();
            }
            this.failedRecords.incrementAndGet();
            this.castledErrorTracker.writeError(dataSinkMessage.getRecord(), pipelineError);
            this.dataSinkMessageOutputStream.writeDataSinkMessage(dataSinkMessage);
        }
        catch (Exception e) {
            log.error(String.format("Write failed record failed for error %s", pipelineError.description()), (Throwable)e);
            throw new CastledRuntimeException((Throwable)e);
        }
    }

    public void flushFailedRecords() throws Exception {
        this.dataSinkMessageOutputStream.flush();
        this.castledErrorTracker.flushErrors();
    }

    public AtomicLong getFailedRecords() {
        return this.failedRecords;
    }

    public Long getFirstFailedMessageId() {
        return this.firstFailedMessageId;
    }
}

