/*
 * Decompiled with CFR 0.152.
 */
package io.castled.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.castled.cache.CastledCache;
import io.castled.oauth.OAuthDAO;
import io.castled.oauth.OAuthDetails;
import io.castled.pubsub.MessageListener;
import io.castled.pubsub.MessageSubscriber;
import io.castled.pubsub.MessageType;
import io.castled.pubsub.registry.Message;
import io.castled.pubsub.registry.OAuthDetailsUpdatedMessage;
import io.castled.utils.TimeUtils;
import org.jdbi.v3.core.Jdbi;

@Singleton
public class OAuthCache
extends CastledCache<Long, OAuthDetails>
implements MessageListener {
    @Inject
    public OAuthCache(Jdbi jdbi, MessageSubscriber messageSubscriber) {
        super(TimeUtils.hoursToMillis((int)3), 1000L, tokenId -> ((OAuthDAO)jdbi.onDemand(OAuthDAO.class)).getOAuthDetails((Long)tokenId), false);
        messageSubscriber.subscribe(MessageType.OAUTH_DETAILS_UPDATED, (MessageListener)this);
    }

    public void handleMessage(Message message) {
        if (message.getType().equals((Object)MessageType.OAUTH_DETAILS_UPDATED)) {
            OAuthDetailsUpdatedMessage oAuthUpdatedMessage = (OAuthDetailsUpdatedMessage)message;
            this.invalidate(oAuthUpdatedMessage.getOauthId());
        }
    }
}

